choose2.pweibull <-
function(formula, data, criteria="AIC", L.max=5, t=NULL, prec=1e-04, max.iter=1000, alpha.fixed=c(1,2))
{ 
if (!inherits(formula, "formula")) {
        if (inherits(formula, "data.frame")) 
            warning("You gave a data.frame instead of a formula.")
        stop("formula is not an object of type formula")
    }
    if (!inherits(data, "data.frame")) {
        if (inherits(data, "formula")) 
            warning("You gave a formula instead of a data.frame.")
        stop("data is not an object of type data.frame")
    }
    if (missing(formula)) 
        stop("Missing formula")
    if (missing(data)) 
        stop("Missing data")
    mf <- model.frame(formula, data)
    Y <- mf[[1]]
    if (!inherits(Y, "Surv")) 
        stop("left hand side not a survival object")
    X1 <- model.matrix(formula, data)
    x <- X1[, -1, drop = FALSE]
    time <- Y[, 1]
    delta <- Y[, 2]
    if (is.null(prec)) 
        stop("prec must be specified")
    if (is.null(max.iter)) 
        stop("max.iter must be specified")
#    if (!is.logical(lambda.identical))
#        stop("lambda.identical must be TRUE or FALSE")
#    if (!is.logical(alpha.identical))
#        stop("alpha.identical must be TRUE or FALSE")
    if(!is.null(t)){
t=c(t); if(!is.vector(t)) stop("t must be a vector")
if (!isTRUE(all.equal(0, t[1]))) 
         stop("first element of t should be 0")
if (is.unsorted(t)) 
        stop("t should be in increasing order")}
    time <- c(time)
    delta <- c(delta)
    max.iter <- round(max.iter)
    if (length(time) != length(delta)) 
        stop("t and delta don't have the same length")
    if (prec > 1) 
        stop("prec is too high")
    if (max.iter <= 0) 
        stop("max.iter at least 1")
    if(!any(criteria==c("AIC","BIC")))
        stop("criteria should be AIC or BIC")
L.max=round(L.max)
if(!is.numeric(L.max)) stop("L.max should be a integer")
if(!any(is.numeric(alpha.fixed))) stop("alpha's should be positive values")
if(any(alpha.fixed<=0)) stop("alpha's should be positive values")
crit=matrix(NA, nrow=L.max, ncol=3+length(alpha.fixed))
aux.min=c()
aux.1=choose.pweibull(formula, data, L.max=L.max, t=t, prec=1e-04, max.iter=1000, criteria=criteria, lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=FALSE)
aux.2=choose.pweibull(formula, data, L.max=L.max, t=t, prec=1e-04, max.iter=1000, criteria=criteria, lambda.identical=TRUE, alpha.identical=FALSE, alpha.fixed=FALSE)
aux.3=choose.pweibull(formula, data, L.max=L.max, t=t, prec=1e-04, max.iter=1000, criteria=criteria, lambda.identical=FALSE, alpha.identical=TRUE, alpha.fixed=FALSE)
if(criteria=="AIC"){
crits=c(aux.1$"AIC", aux.2$"AIC", aux.3$"AIC")
crit[,1]=aux.1$"AIC.L"
crit[,2]=aux.2$"AIC.L"
crit[,3]=aux.3$"AIC.L"
}
if(criteria=="BIC"){ 
crits=c(aux.1$"BIC", aux.2$"BIC", aux.3$"BIC")
crit[,1]=aux.1$"BIC.L"
crit[,2]=aux.2$"BIC.L"
crit[,3]=aux.3$"BIC.L"
}
if(which.min(crits)==1) aux.min=aux.1
if(which.min(crits)==2) aux.min=aux.2
if(which.min(crits)==3) aux.min=aux.3
if(!is.null(alpha.fixed))
{
for(i in 1:length(alpha.fixed))
{
aux.0=choose.pweibull(formula, data, L.max=L.max, t=t, prec=1e-04, max.iter=1000, criteria="AIC", lambda.identical=FALSE, alpha.identical=FALSE, alpha.fixed=alpha.fixed[i])
if(criteria=="AIC"){crit[,i+3]=aux.0$"AIC.L"; if(aux.0$"AIC"<aux.min$"AIC"){aux.min=aux.0}}
if(criteria=="BIC"){crit[,i+3]=aux.0$"BIC.L"; if(aux.0$"BIC"<aux.min$"BIC"){aux.min=aux.0}}
}
}
rownames(crit)=paste("L=",1:L.max,sep="")
colnames(crit)=c("lambda's and alpha's different",
"lambda's equal and alpha's different",
"lambda's different and alpha's equal",
paste("lambda's different and alpha=",alpha.fixed,sep=""))
if(criteria=="AIC") aux.min$"AIC.L"=t(crit)
if(criteria=="BIC") aux.min$"BIC.L"=t(crit)
aux.min
}
