qpweibull <-
function(p, rate = 1, alpha = 1, t = 0, lower.tail = TRUE, log.p = FALSE) 
{
if (length(t) != length(rate)) 
        stop("length of t must be equal to length of rate")
    if (length(t) != length(alpha)) 
        stop("length of t must be equal to length of alpha")
    if (!isTRUE(all.equal(0, t[1]))) 
        stop("first element of t should be 0")
    if (any(alpha<0)) 
        stop("alpha's should be positive values")
    if (is.unsorted(t)) 
        stop("t should be in increasing order")
    if (any(p<0 | p>1)) 
        stop("p should be in (0,1)")
a=c()
for(i in 1:length(p))
{
    a[i]=qgeneric(ppweibull, p = p[i], rate = rate, alpha=alpha, t = t, 
special=c("rate", "alpha", "t"), lower.tail = lower.tail, log.p = log.p)[1]
}
a
}
