% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-predicts-data.R
\name{LoadPredictsData}
\alias{LoadPredictsData}
\title{Load (or download) PREDICTS data to a user-specified RDS file.}
\usage{
LoadPredictsData(file_predicts, extract = c(2016, 2022), force_refresh = FALSE)
}
\arguments{
\item{file_predicts}{Character path to the desired PREDICTS database RDS
file (must end with ".rds").}

\item{extract}{Integer vector of release years to fetch. Defaults to
\code{c(2016, 2022)}.}

\item{force_refresh}{Logical; if TRUE always re-download and overwrite
existing files.}
}
\value{
A dataframe containing the requested PREDICTS extract.
}
\description{
Implements a simple file-based cache. You supply a target filename
(e.g. "data/predicts_2016_2022.rds"). The function will:
\enumerate{
\item Look for that RDS file and the companion metadata file
"filename.aux.json" (e.g. "data/predicts_2016_2022.rds.aux.json").
\item If both exist, verify the file hash, minimal structure, and requested
years.
\item If validation passes return the loaded object.
\item Otherwise download fresh data via \code{GetPredictsData(extract)}, overwrite
the RDS, write a new \code{.aux.json}, and return the dataframe.
}

The data are provided under a CC NC (non-commercial) license, which means
that they cannot be used for commercial purposes. The 2016 release is
available under a CC BY-NC-SA 4.0 license, and the 2022 release is available
under a CC NC (any) license.
}
\examples{
\donttest{
  file_predicts <- file.path(tempdir(), "predicts.rds")
  df_predicts <- LoadPredictsData(file.path(tempdir(), "predicts.rds"))
}

}
