% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_l2.R
\name{norm_l2}
\alias{norm_l2}
\title{L2 Normalization (Unit Vector)}
\usage{
norm_l2(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Remove NAs for norm calculation? Default is \code{TRUE}.}
}
\value{
A numeric vector with an L2 norm of 1.
}
\description{
Scales the vector so that its Euclidean norm (L2 norm) is 1.
This technique is often used in text mining and high-dimensional clustering,
and is related to spatial sign prepkitocessing in robust statistics.
}
\details{
Formula: \eqn{x' = \frac{x}{\sqrt{\sum x^2}}}
}
\examples{
# Convert a vector to unit length
x <- c(3, 4)
norm_l2(x) # Returns c(0.6, 0.8)
}
\references{
Serneels, S., De Nages, E., & Van Espen, P. J. (2006). Spatial sign prepkitocessing: a simple way to impart moderate robustness to multivariate estimators.
\emph{Journal of Chemical Information and Modeling}, 46(3), 1402-1409. \doi{10.1021/ci050498u}

Han, J., Kamber, M., & Pei, J. (2011). \emph{Data mining: concepts and techniques} (3rd ed.). Morgan Kaufmann.
}
