% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_boxcox.R
\name{trans_boxcox}
\alias{trans_boxcox}
\title{Box-Cox Transformation}
\usage{
trans_boxcox(x, lambda = "auto", force_pos = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{lambda}{A numeric value for the transformation power.
If \code{"auto"} (default), the optimal lambda is estimated within the interval [-2, 2].}

\item{force_pos}{Logical. If \code{TRUE} (default), automatically shifts data to be positive
if non-positive values are present.}
}
\value{
A numeric vector with the transformed values.
  The used \code{lambda} and \code{shift} amount are attached as attributes:
  \code{attr(res, "lambda")} and \code{attr(res, "shift")}.
}
\description{
Applies the Box-Cox transformation to normalize the data distribution.
It automatically handles non-positive values by shifting the data.
The optimal lambda parameter is estimated using Maximum Likelihood Estimation (MLE).
}
\references{
Box, G. E. P., & Cox, D. R. (1964). An analysis of transformations.
\emph{Journal of the Royal Statistical Society: Series B (Methodological)}, 26(2), 211-243.
\url{https://www.jstor.org/stable/2984418}
}
