% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvm_priorityelasticnet.R
\name{cvm_priorityelasticnet}
\alias{cvm_priorityelasticnet}
\title{priorityelasticnet with several block specifications}
\usage{
cvm_priorityelasticnet(
  X,
  Y,
  weights,
  family,
  type.measure,
  blocks.list,
  max.coef.list = NULL,
  block1.penalization = TRUE,
  lambda.type = "lambda.min",
  standardize = TRUE,
  nfolds = 10,
  foldid,
  cvoffset = FALSE,
  cvoffsetnfolds = 10,
  alpha = 1,
  ...
)
}
\arguments{
\item{X}{A numeric matrix of predictors.}

\item{Y}{A response vector. For family = "multinomial", Y should be a factor with more than two levels.}

\item{weights}{Optional observation weights. Default is NULL.}

\item{family}{A character string specifying the model type. Options are "gaussian", "binomial", "cox", and "multinomial". Default is "gaussian".}

\item{type.measure}{Loss function for cross-validation. Options are "mse", "deviance", "class", "auc". Default depends on the family.}

\item{blocks.list}{list of the format \code{list(list(bp1=...,bp2=...,), list(bp1=,...,bp2=...,), ...)}. For the specification of the entries, see \code{\link[priorityelasticnet]{priorityelasticnet}}.}

\item{max.coef.list}{list of \code{max.coef} vectors. The first entries are omitted if \code{block1.penalization = FALSE}. Default is \code{NULL}.}

\item{block1.penalization}{Logical. If FALSE, the first block will not be penalized. Default is TRUE.}

\item{lambda.type}{Type of lambda to select. Options are "lambda.min" or "lambda.1se". Default is "lambda.min".}

\item{standardize}{Logical flag for variable standardization, prior to fitting the model. Default is TRUE.}

\item{nfolds}{Number of folds for cross-validation. Default is 10.}

\item{foldid}{Optional vector of values between 1 and \code{nfolds} identifying what fold each observation is in. Default is NULL.}

\item{cvoffset}{Logical. If TRUE, a cross-validated offset is used. Default is FALSE.}

\item{cvoffsetnfolds}{Number of folds for cross-validation of the offset. Default is 10.}

\item{alpha}{Elastic net mixing parameter. The elastic net penalty is defined as 
\deqn{(1 - \alpha)/2||\beta||_2^2 + \alpha||\beta||_1}{(1 - \alpha)/2||\beta||_2^2 + \alpha||\beta||_1}
Defaults to 1 (lasso penalty).}

\item{...}{other arguments that can be passed to the function \code{priorityelasticnet}.}
}
\value{
object of class \code{cvm_priorityelasticnet} with the following elements. Any elements that are lists contain the detailed results (such as coefficients or cross-validation errors) corresponding to each penalized block of the final, optimal model.
\describe{
\item{\code{lambda.ind}}{list with indices of lambda for \code{lambda.type}.}
\item{\code{lambda.type}}{type of lambda which is used for the predictions.}
\item{\code{lambda.min}}{list with values of lambda for \code{lambda.type}.}
\item{\code{min.cvm}}{list with the mean cross-validated errors for \code{lambda.type}.}
\item{\code{nzero}}{list with numbers of non-zero coefficients for \code{lambda.type}.}
\item{\code{glmnet.fit}}{list of fitted \code{glmnet} objects.}
\item{\code{name}}{a text string indicating type of measure.}
\item{\code{block1unpen}}{if \code{block1.penalization = FALSE}, the results of either the fitted \code{glm} or \code{coxph} object.}
\item{\code{best.blocks}}{character vector with the indices of the best block specification.}
\item{\code{best.blocks.indices}}{list with the indices of the best block specification ordered by best to worst.}
\item{\code{best.max.coef}}{A vector containing the maximum number of non-zero coefficients (selected variables) allowed for each penalized block, corresponding to the model chosen as optimal by cross-validation \code{best.blocks}.}
\item{\code{best.model}}{complete \code{priorityelasticnet} model of the best solution.}
\item{\code{coefficients}}{coefficients according to the results obtained with \code{best.blocks}.}
\item{\code{call}}{the function call.}
}
}
\description{
Runs priorityelasticnet for a list of block specifications and gives the best results
in terms of cv error.
}
\note{
The function description and the first example are based on the R package \code{ipflasso}.
}
