% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProtein3D.R
\name{plot3D}
\alias{plot3D}
\title{plot3D}
\usage{
plot3D(
  protein,
  animated = FALSE,
  type = "p",
  groups = NULL,
  screen = list(x = -60, z = 0, y = 0),
  image_width = 480,
  image_height = 480
)
}
\arguments{
\item{protein}{Protein object to be plotted. Can be either of S3 or S4 Protien
object type.}

\item{animated}{logical indicating whether the object is to be animated in the
viewer. Will spin the plot on the Z axis.}

\item{type}{character vector indicating the type of cloud plot. Can include one
or more of "p", "l", "h", or "b". "p" and "l" mean points and lines respectively,
and "b" means both. "h" stands for histogram and draws lines from each point
to the XY plane, either lower or upper bounding box face, whichever is closer.}

\item{groups}{the name of a column from the Atomic Record of the protein. Causes
the points to be colored by the different values in that group.}

\item{screen}{A list determining the sequence of rotations to be applied to the
data before plotting. Each componenet of the list should be one of "x", "y"
or "z", repetitions are allowed with values indicating amount of rotation in
degrees.}

\item{image_width}{width of the resulting image in pixels. Currently only applies
when `animated = TRUE`. Defaults to 480 pixels.}

\item{image_height}{hieght of the resulting image in pixels. Currently only applies
when `animated = TRUE`. Defaults to 480 pixels.}
}
\value{
An object to be plotted. If not assigned to a variable, it will plot
 directly in the viewer.
}
\description{
plot the protein structure in 3D
}
\details{
This function uses lattice and magick to create the 3D plot and animate
 it.

Currently this function is incomplete and will change dramatically as
 new features and documentation are added.
}
