% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pscDesign.R
\name{pscDesign}
\alias{pscDesign}
\title{Study design using Personalised Synthetic Controls}
\usage{
pscDesign(
  CFM,
  n0 = 0,
  n1,
  beta,
  fuTime,
  recTime,
  rec = NULL,
  nsim = 4,
  nsim.psc = 500,
  burn.psc = 200,
  bound = 0,
  direction = "greater",
  alpha_eval = c(0.01, 0.025, 0.05, 0.1, 0.15, 0.2)
)
}
\arguments{
\item{CFM}{a Counter-Factual model}

\item{n0}{number of patients allocated to the control arm (defaults to 0 -
i.e. single arm study).}

\item{n1}{number of patients allocated to the experimental arm}

\item{beta}{the (log) HR used in the study design}

\item{fuTime}{Follow up time for the study design}

\item{recTime}{Recruitment time for the study design}

\item{rec}{a study recruitment estimate obtained using the recForcast()
function. If specified, recTime will be ignored.}

\item{nsim}{number of simulations}

\item{nsim.psc}{number of simulations to use in psc estimation}

\item{burn.psc}{burn in to use in psc estimation}

\item{bound}{The bound to use in the posterior evaluation (defaults to 0)}

\item{direction}{The direction which specifies superiority of the efficacy
parameter}

\item{alpha_eval}{Alpha values at which to evaluate the study design.}
}
\value{
A list containing a summary of the simulated datasets and estimated
type-II error rates (Power) against leveld of significance (alpha-levels)
}
\description{
pscDesign performs the simulations required to estimate the Power of a study
designed using personalised synthetic controls.
}
\details{
The pscDesign function performs a simulation study to estimate the design
parameters for a study using personalised synthetic controls.

Time parameters (fuTime, recTime) should be expressed on the same scale on
which they are specified in the Counter Factual Model.  One of recTime or rec
must be specified. If rec is specified, recTime will be ignored.
}
\examples{
gemCFM <- pscDesign::gemCFM
pscDesign(gemCFM,n0=0,n1=100,beta=log(0.7),fuTime=12,recTime=12,nsim=2,
    nsim.psc=300,burn.psc=100)
}
