% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_complikel.R
\name{rwe_cl}
\alias{rwe_cl}
\title{Composite Likelihood Estimation}
\usage{
rwe_cl(
  dta_cur,
  dta_ext,
  n_borrow = 0,
  outcome_type = c("continuous", "binary"),
  equal_sd = TRUE
)
}
\arguments{
\item{dta_cur}{Vector of outcome from a PS stratum in the current study}

\item{dta_ext}{Vector of outcome from a PS stratum in the external data source}

\item{n_borrow}{Number of subjects to be borrowed}

\item{outcome_type}{Type of outcomes: \code{continuous} or \code{binary}.}

\item{equal_sd}{Boolean. whether sd is the same between the current study and
external data source}
}
\value{
Maximum composite likelihood estimator of the mean
}
\description{
Estimate parameter of interest based on composite likelihood for a single PS
stratum
}
\examples{
x <- rnorm(100,  mean = 0, sd = 1)
y <- rnorm(1000, mean = 1, sd = 2)
rwe_cl(x, y, n_borrow = 20, equal_sd = FALSE)

}
