% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bland_altman}
\alias{bland_altman}
\title{Bland-Altman agreement plots.}
\usage{
bland_altman(data, x, y, size = 1, transform = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{x}{A numerical variable.}

\item{y}{A numerical variable.}

\item{size}{Size of the symbol using to plot data.}

\item{transform}{Logical, should ratios instead of differences be used to construct the plot?}
}
\description{
Bland-Altman agreement plots.
}
\details{
\code{bland_altman} constructs Bland-Altman agreement plots.

Variables in \code{formula} are continuous paired observations. When the distribution of the outcome
is not normal, but becomes normal with a log-transformation, \code{bland_altman} can plot the ratio between
outcomes (difference in the log scale) by using option \code{transform = TRUE}.
}
\examples{
data(Sharples)

Sharples |>
  bland_altman(
    x = weight, y = srweight,
    transform = TRUE, size = 0.7
  ) +
  xlab("Mean of weights (kg)") +
  ylab("Measured / Self-reported weight")
}
