## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(purrr)

## -----------------------------------------------------------------------------
x <- 1:3

triple <- function(x) x * 3
out <- map(x, triple)
str(out)

## -----------------------------------------------------------------------------
x |>
  map(triple) |>
  str()

## -----------------------------------------------------------------------------
out <- vector("list", 3)
for (i in seq_along(x)) {
  out[[i]] <- triple(x[[i]])
}
str(out)

## -----------------------------------------------------------------------------
# out <- map(1:100, \(i) Sys.sleep(0.5), .progress = TRUE)

## -----------------------------------------------------------------------------
# mirai::daemons(6)

## -----------------------------------------------------------------------------
mirai::daemons(sync = TRUE)

## -----------------------------------------------------------------------------
out <- map(1:5, in_parallel(\(i) Sys.sleep(0.5)))

## -----------------------------------------------------------------------------
try({
my_lm <- function(formula, data) {
  Sys.sleep(0.5)
  lm(formula, data)
}
by_cyl <- split(mtcars, mtcars$cyl)
out <- map(by_cyl, in_parallel(\(df) my_lm(mpg ~ disp, data = df)))
})

## -----------------------------------------------------------------------------
out <- map(by_cyl, in_parallel(\(df) my_lm(mpg ~ disp, data = df), my_lm = my_lm))

## -----------------------------------------------------------------------------
mirai::daemons(0)

## -----------------------------------------------------------------------------
mtcars |>
  split(mtcars$cyl) |> # from base R
  map(\(df) lm(mpg ~ wt, data = df)) |>
  map(summary) |>
  map_dbl(\(x) x$r.squared)

## -----------------------------------------------------------------------------
xs <- map(1:8, ~ runif(10))
xs[[1]][[1]] <- NA
ws <- map(1:8, ~ rpois(10, 5) + 1)

## -----------------------------------------------------------------------------
map_dbl(xs, mean)

## -----------------------------------------------------------------------------
map2_dbl(xs, ws, weighted.mean)

## -----------------------------------------------------------------------------
map2_dbl(xs, ws, weighted.mean, na.rm = TRUE)

## -----------------------------------------------------------------------------
# map2_dbl(xs, ws, \(x, w) weighted.mean(x, w, na.rm = TRUE))

## -----------------------------------------------------------------------------
x <- list(
  a = letters[1:10],
  b = 1:10,
  c = runif(15)
)

x |> detect(is.character)
x |> detect_index(is.numeric)

x |> keep(is.numeric) |> str()
x |> discard(is.numeric) |> str()

x |> every(\(x) length(x) > 10)
x |> some(\(x) length(x) > 10)
x |> none(\(x) length(x) == 0)

