% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmed7.R
\name{modmed7}
\alias{modmed7}
\title{Compute Power for Model 7 Conditional Processes Using Joint Significance
Requires correlations between all variables as sample size
Several values default to zero if no value provided
This is the recommended approach for determining power}
\usage{
modmed7(
  rxm,
  rxw,
  rxxw = 0,
  rxy,
  rwm,
  rwxw = 0,
  rwy = 0,
  rmxw,
  rmy,
  rxwy = 0,
  alpha = 0.05,
  rep = 1000,
  n = NULL
)
}
\arguments{
\item{rxm}{Correlation between predictor (x) and mediator (m)}

\item{rxw}{Correlation between predictor (x) and moderator (w)}

\item{rxxw}{Correlation between predictor (x) and interaction term (xw) - defaults to 0}

\item{rxy}{Correlation between DV (y) and predictor (x)}

\item{rwm}{Correlation between moderator (w) and mediator (m)}

\item{rwxw}{Correlation between moderator (w) and interaction (xw) - defaults to 0}

\item{rwy}{Correlation between DV (y) and moderator (w)}

\item{rmxw}{Correlation between mediator (m) and interaction (xw) - Key value}

\item{rmy}{Correlation between DV (y) and mediator (m)}

\item{rxwy}{Correlation between DV (y) and interaction (xw) - defaults to 0}

\item{alpha}{Type I error (default is .05)}

\item{rep}{Number of samples drawn (defaults to 5000)}

\item{n}{Sample size}
}
\value{
Power for Model 7 Conditional Processes
}
\description{
Compute Power for Model 7 Conditional Processes Using Joint Significance
Requires correlations between all variables as sample size
Several values default to zero if no value provided
This is the recommended approach for determining power
}
\examples{
\donttest{modmed7(rxm=.4, rxw=.2, rxy=.3, rwm=.2, rmxw=.1, rmy=.3,n=200)}
}
