% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qryflow.R
\name{qryflow_run}
\alias{qryflow_run}
\title{Parse and execute a tagged SQL workflow}
\usage{
qryflow_run(con, sql, ...)
}
\arguments{
\item{con}{A database connection from \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{sql}{A character string representing either the path to a \code{.sql} file or raw SQL content.}

\item{...}{Additional arguments passed to \code{\link[=qryflow_execute]{qryflow_execute()}}.}
}
\value{
A list representing the evaluated workflow, containing query results, execution metadata,
or both, depending on the contents of the SQL script.
}
\description{
\code{qryflow_run()} reads a SQL workflow from a file path or character string, parses it into
tagged statements, and executes those statements against a database connection.

This function is typically used internally by \code{\link[=qryflow]{qryflow()}}, but can also be called directly
for more control over workflow execution.
}
\examples{
con <- example_db_connect(mtcars)

filepath <- example_sql_path("mtcars.sql")

obj <- qryflow_run(con, filepath)

obj$df_mtcars$sql
obj$df_mtcars$results

results <- qryflow_results(obj)

head(results$df_mtcars$results)

DBI::dbDisconnect(con)
}
\seealso{
\code{\link[=qryflow]{qryflow()}}, \code{\link[=qryflow_results]{qryflow_results()}}, \code{\link[=qryflow_execute]{qryflow_execute()}}, \code{\link[=qryflow_parse]{qryflow_parse()}}
}
