% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quant_es_file_helpers.R
\name{quant_es_from_binary_table}
\alias{quant_es_from_binary_table}
\title{Read a flat binary table and run quant_es_core}
\usage{
quant_es_from_binary_table(
  path,
  sep = "\\t",
  header = TRUE,
  variant_col = NULL
)
}
\arguments{
\item{path}{Path to a text file.}

\item{sep}{Field separator (default tab).}

\item{header}{Whether the file has a header.}

\item{variant_col}{Column name containing the variant IDs.
If NULL and no such column exists, sequential IDs will be created.}
}
\value{
A standard quantbayes result list.
}
\description{
Reads a TSV, CSV or other delimited file where:
\itemize{
\item the first column is a variant identifier (unless removed)
\item remaining columns contain binary 0, 1, or NA evidence indicators.
}
}
\examples{
tmp <- tempfile(fileext = ".tsv")
write.table(core_test_data, tmp, sep = "\t", quote = FALSE, row.names = FALSE)
res <- quant_es_from_binary_table(tmp)
res$global

}
