% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quarto.R
\name{quarto_available}
\alias{quarto_available}
\title{Check if quarto is available and version meet some requirements}
\usage{
quarto_available(min = NULL, max = NULL, error = FALSE)
}
\arguments{
\item{min}{Minimum version expected.}

\item{max}{Maximum version expected}

\item{error}{If \code{TRUE}, will throw an error if Quarto is not available or does not meet the requirement. Default is \code{FALSE}.}
}
\value{
logical. \code{TRUE} if requirement is met, \code{FALSE} otherwise.
}
\description{
This function allows to test if Quarto is available and meets version requirement, a min, max or
in between requirement.
}
\details{
If \code{min} and \code{max} are provided, this will check if Quarto version is
in-between two versions. If non is provided (keeping the default \code{NULL} for
both), it will just check for Quarto availability version and return \code{FALSE} if not found.
}
\examples{
# Is there an active version available ?
quarto_available()
# check for a minimum requirement
quarto_available(min = "1.5")
# check for a maximum version
quarto_available(max = "1.6")
# only returns TRUE if Pandoc version is between two bounds
quarto_available(min = "1.4", max = "1.6")

}
