% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_multivariate.R
\name{detect_multivariate}
\alias{detect_multivariate}
\title{Detect Multivariate Anomalies (Mahalanobis Distance)}
\usage{
detect_multivariate(data, columns, confidence_level = 0.99)
}
\arguments{
\item{data}{A data frame.}

\item{columns}{Vector of column names to analyze (must be numeric).}

\item{confidence_level}{Numeric (0 to 1). The confidence cutoff for the Chi-square distribution. Defaults to 0.99 (99\%).}
}
\value{
A data frame with the multivariate outliers and their Mahalanobis distance.
}
\description{
Identifies outliers based on the relationship between multiple variables using Mahalanobis Distance.
This is useful when individual values are normal, but their combination is anomalous (e.g., high weight for low height).
}
\examples{
# Generate dataset (n=50) with strong correlation
df <- data.frame(x = rnorm(50), y = rnorm(50))
df$y <- df$x * 2 + rnorm(50, sd = 0.5) # y depends on x

# Add an anomaly: normal x, but impossible y
anomaly <- data.frame(x = 0, y = 10)
df <- rbind(df, anomaly)

# Detect
detect_multivariate(df, columns = c("x", "y"))
}
