% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rtf.R
\name{write_html}
\alias{write_html}
\title{Write an RTF Table or Figure to an HTML File}
\usage{
write_html(rtf, file)
}
\arguments{
\item{rtf}{A character rtf encoding string rendered by \code{rtf_encode()}.}

\item{file}{A character string naming a file to save html file.}
}
\description{
The write_html function writes an RTF encoding string to an .html file
by first writing to a temporary RTF file and then converting it to HTML
using LibreOffice.
}
\details{
This function requires LibreOffice to be installed on the system.
The function uses the internal \code{rtf_convert_format()} function
to perform the conversion from RTF to HTML format.

Currently only Unix/Linux/macOS systems are supported.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Write RTF encoding to a temporary RTF file.
   \item Convert RTF to HTML using LibreOffice command-line tool via \code{rtf_convert_format()}.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

