% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_slides.R
\name{write_slides}
\alias{write_slides}
\title{Create a Quarto slide deck template}
\usage{
write_slides(
  filenames,
  path = here(),
  new_folder = "slides",
  example = FALSE,
  template = "none",
  format = "revealjs"
)
}
\arguments{
\item{filenames}{Character vector with minimal length of 1. This allows for the ability
to batch create multiple slide decks in one function call.}

\item{path}{Character string. Directory where the file will be created. Defaults to
the current project's base directory.}

\item{new_folder}{Character. Default folder is \code{"slides"}. Options are:
\itemize{
\item \code{"none"}: No folder is created. All files (.qmd & other) are created
in the working directory (path of \code{here::here()}).
\item \code{"all"}: One folder is created for each value in the length of
\code{filenames}.
\item \code{"slide_"}: One folder is created by appending "slides_" to the first file
in \code{filenames} argument. If \code{filenames = "day_1"}, then the folder will
be named \code{"slides_day_1"}.
\item A character value.
}}

\item{example}{Logical. Whether to include example slides with demonstrations of
including content.}

\item{template}{Character. Whether to include a slide template for common slide
layouts and formatting (default: "none")
\itemize{
\item optional: \code{"miami"} for a University of Miami theme.
\item optional: \code{"rmed"} for a R/Med theme.
}}

\item{format}{Character string. Slide format to use. Currently supports 'reveal.js',
with planned support for PowerPoint and Beamer in future releases.}
}
\value{
Invisibly returns NULL. The created .qmd file is automatically opened
in the RStudio editor upon successful creation.
}
\description{
Creates a pre-formatted .qmd file for presentation slides using reveal.js
along with necessary supporting files (SCSS styling and RStudio theme). The
generated template includes optimized YAML configuration and slide structure
to quickly start building academic & professional presentations. For more
information look in the
\href{../doc/ah_write_slides.html}{Creating Slides with write_slides()} vignette.
}
\details{
The function creates three files:
\itemize{
\item A .qmd file with the specified filename containing the slide template
\item A slides.scss file for custom styling
\item An RStudio theme file for consistent code highlighting
}

All filenames must contain only letters, numbers, hyphens, and underscores.
}
\note{
Be sure to specify \code{path = "inst"} if you are adding slides to a package.
}
\examples{
if (interactive()) {
  # Create basic slides template in current directory
  write_slides(filenames = "my_presentation")

  # Create slides with example content in a specific directory
  tmp <- tempdir()
  write_slides(filenames = "tutorial_slides", path = tmp, example = TRUE)

  # Create a slidedeck for a package in the inst directory
  tmp <- tempdir()
  write_slides(filenames = "tutorial_slides", path = 'inst', example = TRUE)
}

}
