% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.r
\name{print.rdt}
\alias{print.rdt}
\alias{print.srt}
\alias{print.rdpmedian}
\alias{print.pmedian}
\title{Print results}
\usage{
\method{print}{rdt}(x, digits = 3, ...)

\method{print}{srt}(x, digits = 3, ...)

\method{print}{rdpmedian}(x, digits = 3, ...)

\method{print}{pmedian}(x, digits = 3, ...)
}
\arguments{
\item{x}{Objects returned by:
\itemize{
\item \code{\link[=rdt]{rdt()}} or \code{\link[=rdt2]{rdt2()}}
\item \code{\link[=srt]{srt()}} or \code{\link[=srt2]{srt2()}}
\item \code{\link[=rdpmedian]{rdpmedian()}} or \code{\link[=rdpmedian2]{rdpmedian2()}}
\item \code{\link[=pmedian]{pmedian()}} or \code{\link[=pmedian2]{pmedian2()}}
}}

\item{digits}{(Scalar integer: \code{3}; \verb{[1, Inf)})\cr
The number of significant digits to use.}

\item{...}{Unused additional arguments.}
}
\value{
\code{invisible(x)}
}
\description{
Prints results in the style of \code{htest}.
}
\examples{
#----------------------------------------------------------------------------
# print() examples
#----------------------------------------------------------------------------
library(rankdifferencetest)

# Use example data from Kornbrot (1990)
data <- kornbrot_table1

rdt(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95,
  alternative = "two.sided",
  distribution = "asymptotic",
  zero_method = "wilcoxon",
  correct = FALSE
) |>
  print()

srt(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95,
  alternative = "two.sided",
  distribution = "asymptotic",
  zero_method = "wilcoxon",
  correct = FALSE
) |>
  print()

rdpmedian(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95
) |>
  print()

pmedian(
  data = data,
  formula = placebo ~ drug,
  conf_level = 0.95
) |>
  print()

}
