% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_cholhdl_ratio.R
\name{extract_cholhdl_ratio}
\alias{extract_cholhdl_ratio}
\title{Extract most recent total cholesterol/high-density lipoprotein ratio score relative to an index date.}
\usage{
extract_cholhdl_ratio(
  cohort,
  varname = NULL,
  codelist_ratio = NULL,
  codelist_chol = NULL,
  codelist_hdl = NULL,
  codelist_ratio_vector = NULL,
  codelist_chol_vector = NULL,
  codelist_hdl_vector = NULL,
  codelist_ratio_df = NULL,
  codelist_chol_df = NULL,
  codelist_hdl_df = NULL,
  indexdt,
  t = NULL,
  t_varname = TRUE,
  time_prev = 365.25 * 5,
  time_post = 0,
  lower_bound = -Inf,
  upper_bound = Inf,
  db_open = NULL,
  db = NULL,
  db_filepath = NULL,
  table_name = NULL,
  out_save_disk = FALSE,
  out_subdir = NULL,
  out_filepath = NULL,
  return_output = TRUE
)
}
\arguments{
\item{cohort}{Cohort to extract age for.}

\item{varname}{Optional name for variable in output dataset.}

\item{codelist_ratio}{Name of codelist (stored on hard disk in "codelists/analysis/") for ratio to query the database with.}

\item{codelist_chol}{Name of codelist (stored on hard disk in "codelists/analysis/") for total cholesterol to query the database with.}

\item{codelist_hdl}{Name of codelist (stored on hard disk in "codelists/analysis/") for high-density lipoprotein to query the database with.}

\item{codelist_ratio_vector}{Vector of codes for ratio to query the database with.}

\item{codelist_chol_vector}{Vector of codes for total cholesterol to query the database with.}

\item{codelist_hdl_vector}{Vector of codes for high-density lipoprotein to query the database with.}

\item{codelist_ratio_df}{data.frame of codes for ratio to query the database with.}

\item{codelist_chol_df}{data.frame of codes for total cholesterol to query the database with.}

\item{codelist_hdl_df}{data.frame of codes for high-density lipoprotein to query the database with.}

\item{indexdt}{Name of variable which defines index date in \code{cohort}.}

\item{t}{Number of days after index date at which to calculate variable.}

\item{t_varname}{Whether to add \code{t} to \code{varname}.}

\item{time_prev}{Number of days prior to index date to look for codes.}

\item{time_post}{Number of days after index date to look for codes.}

\item{lower_bound}{Lower bound for returned values.}

\item{upper_bound}{Upper bound for returned values.}

\item{db_open}{An open SQLite database connection created using RSQLite::dbConnect, to be queried.}

\item{db}{Name of SQLITE database on hard disk (stored in "data/sql/"), to be queried.}

\item{db_filepath}{Full filepath to SQLITE database on hard disk, to be queried.}

\item{table_name}{Specify name of table in the SQLite database to be queried, if this is different from 'observation'.}

\item{out_save_disk}{If \code{TRUE} will attempt to save outputted data frame to directory "data/extraction/".}

\item{out_subdir}{Sub-directory of "data/extraction/" to save outputted data frame into.}

\item{out_filepath}{Full filepath and filename to save outputted data frame into.}

\item{return_output}{If \code{TRUE} will return outputted data frame into R workspace.}
}
\value{
A data frame with variable total cholesterol/high-density lipoprotein ratio.
}
\description{
Extract most recent total cholesterol/high-density lipoprotein ratio score relative to an index date.
}
\details{
Cholesterol/HDL ratio can either be identified through a directly recorded cholesterol/hdl ratio score, or calculated via total cholesterol and HDL scores.
Full details on the algorithm for extracting cholesterol/hdl ratio are given in the vignette: Details-on-algorithms-for-extracting-specific-variables.
This vignette can be viewed by running \code{vignette("help", package = "rcprd")}.

Specifying \code{db} requires a specific underlying directory structure. The SQLite database must be stored in "data/sql/" relative to the working directory.
If the SQLite database is accessed through \code{db}, the connection will be opened and then closed after the query is complete. The same is true if
the database is accessed through \code{db_filepath}. A connection to the SQLite database can also be opened manually using \code{RSQLite::dbConnect}, and then
using the object as input to parameter \code{db_open}. After wards, the connection must be closed manually using \code{RSQLite::dbDisconnect}. If \code{db_open} is specified, this will take precedence over \code{db} or \code{db_filepath}.

If \code{out_save_disk = TRUE}, the data frame will automatically be written to an .rds file in a subdirectory "data/extraction/" of the working directory.
This directory structure must be created in advance. \code{out_subdir} can be used to specify subdirectories within "data/extraction/". These options will use a default naming convetion. This can be overwritten
using \code{out_filepath} to manually specify the location on the hard disk to save. Alternatively, return the data frame into the R workspace using \code{return_output = TRUE}
and then save onto the hard disk manually.

Specifying the non-vector type codelists requires a specific underlying directory structure. The codelist on the hard disk must be stored in "codelists/analysis/" relative
to the working directory, must be a .csv file, and contain a column "medcodeid", "prodcodeid" or "ICD10" depending on the chosen \code{tab}. The input
to these variables should just be the name of the files (excluding the suffix .csv). The codelists can also be read in manually, and supplied as a
character vector. This option will take precedence over the codelists stored on the hard disk if both are specified.

The argument \code{table_name} is only necessary if the name of the table being queried does not match 'observation'. This will occur when
\code{str_match} is used in \code{cprd_extract} or \code{add_to_database} to create the .sqlite database.
}
\examples{

## Connect
aurum_extract <- connect_database(file.path(tempdir(), "temp.sqlite"))

## Create SQLite database using cprd_extract
cprd_extract(aurum_extract,
filepath = system.file("aurum_data", package = "rcprd"),
filetype = "observation", use_set = FALSE)

## Define cohort and add index date
pat<-extract_cohort(system.file("aurum_data", package = "rcprd"))
pat$indexdt <- as.Date("01/01/1955", format = "\%d/\%m/\%Y")

## Extract most recent cholhdl_ratio prior to index date
extract_cholhdl_ratio(cohort = pat,
codelist_ratio_vector = "498521000006119",
codelist_chol_vector = "401539014",
codelist_hdl_vector = "13483031000006114",
indexdt = "indexdt",
time_prev = Inf,
db_open = aurum_extract,
return_output = TRUE)

## clean up
RSQLite::dbDisconnect(aurum_extract)
unlink(file.path(tempdir(), "temp.sqlite"))

}
