% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs_broadacre_data.R
\name{read_abs_broadacre_data}
\alias{read_abs_broadacre_data}
\title{Get ABS' Broadacre Crops Production and Value by Australia, State and Territory by Year}
\usage{
read_abs_broadacre_data(data_set = "winter", year = "latest", x = NULL)
}
\arguments{
\item{data_set}{A character vector providing the desired cropping data, one
of:
\itemize{
\item winter (default),
\item summer or
\item sugarcane.
}}

\item{year}{A string value providing the year of interest to download.
Formatted as \code{"2022-23"} or \code{"2023-24"} or use \code{"latest"} for the most
recent release available. Defaults to \code{"latest"}.}

\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} object of the requested data.
}
\description{
Automates downloading and importing of \acronym{ABS} broadacre crop
production data. Please view the comments embedded in the spreadsheets
themselves (that really should be columns of comments on the data) for
important information.
}
\details{
Technically these data are from the Australian Bureau of Statistics
(\acronym{ABS}, not \acronym{ABARES}, but the data is agricultural and so
it's serviced in this package.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
broadacre_data  <- read_abs_broadacre_data()

broadacre_data
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.abs.gov.au/statistics/industry/agriculture/australian-agriculture-broadacre-crops}.
}
\seealso{
Other ABS: 
\code{\link{read_abs_horticulture_data}()},
\code{\link{read_abs_livestock_data}()}
}
\concept{ABS}
