% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_estimates_by_performance_category.R
\name{read_estimates_by_performance_category}
\alias{read_estimates_by_performance_category}
\alias{read_est_by_perf_cat}
\title{Read ABARES' "Estimates by Performance Category" Data}
\source{
()\url{https://www.agriculture.gov.au/sites/default/files/documents/fdp-BySize-ByPerformance.csv}.
}
\usage{
read_estimates_by_performance_category(x = NULL)

read_est_by_perf_cat(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} object.
}
\description{
Fetches and imports \acronym{ABARES} estimates by performance category data.
}
\note{
Columns are renamed for consistency with other \acronym{ABARES} products
serviced in this package using a snake_case format and ordered consistently.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}

read_estimates_by_performance_category()

# or shorter
read_est_by_perf_cat()
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.agriculture.gov.au/abares/data/farm-data-portal#data-download}.
}
\seealso{
Other Estimates: 
\code{\link{read_estimates_by_size}()},
\code{\link{read_historical_national_estimates}()},
\code{\link{read_historical_regional_estimates}()},
\code{\link{read_historical_state_estimates}()}
}
\concept{Estimates}
