% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_historical_state_estimates.R
\name{read_historical_state_estimates}
\alias{read_historical_state_estimates}
\alias{read_hist_st_est}
\title{Read ABARES' "Historical State Estimates"}
\source{
\url{https://www.agriculture.gov.au/sites/default/files/documents/fdp-state-historical.csv}.
}
\usage{
read_historical_state_estimates(x = NULL)

read_hist_st_est(x = NULL)
}
\arguments{
\item{x}{A file path providing the file with the data to be imported. The
file is assumed to be unarchived (\emph{i.e.}, still zipped). This function does
not provide any checking whether this function is the proper function for
the provided file.  Defaults to \code{NULL}, assuming that the file will be
downloaded in the active \R session.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} object with the \code{Variable} field as the
\code{key}.
}
\description{
Fetches and imports \acronym{ABARES} "Historical State Estimates" data.
}
\note{
Columns are renamed for consistency with other \acronym{ABARES} products
serviced in this package using a snake_case format and ordered consistently.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
read_historical_state_estimates()

# or shorter
read_hist_st_est()
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.agriculture.gov.au/abares/data/farm-data-portal#data-download}.
}
\seealso{
Other Estimates: 
\code{\link{read_estimates_by_performance_category}()},
\code{\link{read_estimates_by_size}()},
\code{\link{read_historical_national_estimates}()},
\code{\link{read_historical_regional_estimates}()}
}
\concept{Estimates}
