% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_clum_metadata_pdf.R
\name{view_clum_metadata_pdf}
\alias{view_clum_metadata_pdf}
\title{Displays the PDF Metadata for ABARES' "Catchment Land Use" (CLUM) Raster Files in a Native Viewer}
\source{
\describe{
\item{CLUM Metadata}{https://www.agriculture.gov.au/sites/default/files/documents/CLUM_DescriptiveMetadata_December2023_v2.pdf}
\item{CLUM Commodities Metadata}{https://www.agriculture.gov.au/sites/default/files/documents/CLUMC_DescriptiveMetadata_December2023.pdf}
}
}
\usage{
view_clum_metadata_pdf(commodities = FALSE)
}
\arguments{
\item{commodities}{A \code{Boolean} value that indicates whether to download the
catchment land scale use metadata for commodities. Defaults to \code{FALSE},
downloading the "Catchment Land Scale Use Metadata".}
}
\value{
An invisible \code{NULL}. Called for its side-effects, opens the system's
native \acronym{PDF} viewer to display the requested metadata \acronym{PDF}
document.
}
\description{
Each "Catchment Land Use" (\acronym{CLUM}) raster file comes with a
\acronym{PDF} of metadata. This function will open and display that file
using the native \acronym{PDF} viewer for any system with a graphical user
interface and \acronym{PDF} viewer configured.  If the file does not exist
locally, it will be fetched and displayed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
view_clum_metadata_pdf()
\dontshow{\}) # examplesIf}
}
\seealso{
Other nlum: 
\code{\link{read_nlum_stars}()},
\code{\link{read_nlum_terra}()},
\code{\link{view_nlum_metadata_pdf}()}
}
\concept{nlum}
