% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldValidationAndCasting.R
\docType{data}
\name{fieldValidationAndCasting}
\alias{fieldValidationAndCasting}
\alias{isNAorBlank}
\alias{valRx}
\alias{valChoice}
\alias{valPhone}
\alias{valSkip}
\alias{na_values}
\alias{castLabel}
\alias{castLabelCharacter}
\alias{castCode}
\alias{castCodeCharacter}
\alias{castRaw}
\alias{castChecked}
\alias{castCheckedCharacter}
\alias{castCheckLabel}
\alias{castCheckLabelCharacter}
\alias{castCheckCode}
\alias{castCheckCodeCharacter}
\alias{castCheckForImport}
\alias{castDpNumeric}
\alias{castDpCharacter}
\alias{castTimeHHMM}
\alias{castTimeMMSS}
\alias{castLogical}
\alias{raw_cast}
\alias{default_cast_no_factor}
\alias{default_cast_character}
\alias{skip_validation}
\title{Helper functions for \code{exportRecordsTyped} Validation and Casting}
\format{
An object of class \code{list} of length 21.

An object of class \code{list} of length 25.

An object of class \code{list} of length 25.

An object of class \code{list} of length 21.
}
\usage{
isNAorBlank(x, ...)

valRx(rx)

valChoice(x, field_name, coding)

valPhone(x, field_name, coding)

valSkip(x, field_name, coding)

na_values(FUN)

castLabel(x, field_name, coding)

castLabelCharacter(x, field_name, coding)

castCode(x, field_name, coding)

castCodeCharacter(x, field_name, coding)

castRaw(x, field_name, coding)

castChecked(x, field_name, coding)

castCheckedCharacter(x, field_name, coding)

castCheckLabel(x, field_name, coding)

castCheckLabelCharacter(x, field_name, coding)

castCheckCode(x, field_name, coding)

castCheckCodeCharacter(x, field_name, coding)

castCheckForImport(checked = c("Checked", "1"))

castDpNumeric(dec_symbol = ",")

castDpCharacter(n_dec, dec_symbol = ",")

castTimeHHMM(x, field_name, coding)

castTimeMMSS(x, field_name, coding)

castLogical(x, field_name, coding)

raw_cast

default_cast_no_factor

default_cast_character

skip_validation
}
\arguments{
\item{x}{\code{character}. A vector to check.}

\item{...}{Consumes anything else passed to function. I.e., field_name and
coding.}

\item{rx}{\code{character}. The regular expression pattern to check.}

\item{field_name}{\code{character(1)}. Name of the field(s)}

\item{coding}{named \code{character} vector. The defined coding from the meta data.}

\item{FUN}{\code{function}. A function that takes a character vector.}

\item{checked}{\code{character}. Values to recognize as checked in a
checkbox field.}

\item{dec_symbol}{\code{character(1)}. The symbol in the field used to
denote a decimal.}

\item{n_dec}{\code{integerish(1)}. The number of decimal places permitted
by the field validation.}
}
\value{
Validation and casting functions return the objects indicated in the
following table:\tabular{ll}{
   Function Name \tab Object Type Returned \cr
   \code{isNAOrBlank} \tab \code{logical} \cr
   \code{valRx} \tab \code{logical} \cr
   \code{valChoice} \tab \code{logical} \cr
   \code{valPhone} \tab \code{logical} \cr
   \code{valSkip} \tab \code{logical} \cr
   \code{castLabel} \tab \code{factor} \cr
   \code{castLabelCharacter} \tab \code{character} \cr
   \code{castCode} \tab \code{factor} \cr
   \code{castCodeCharacter} \tab \code{character} \cr
   \code{castRaw} \tab \code{character} \cr
   \code{castChecked} \tab \code{factor} \cr
   \code{castCheckedCharacter} \tab \code{character} \cr
   \code{castCheckLabel} \tab \code{factor} \cr
   \code{castCheckLabelCharacter} \tab \code{character} \cr
   \code{castCheckCode} \tab \code{factor} \cr
   \code{castCheckCodeCharacter} \tab \code{character} \cr
   \code{castCheckForImport} \tab \code{numeric} \cr
   \code{castDpNumeric} \tab \code{numeric} \cr
   \code{castDpCharacter} \tab \code{character} \cr
   \code{castTimeHHMM} \tab \code{character} \cr
   \code{castTimeMMSS} \tab \code{character} \cr
   \code{castLogical} \tab \code{logical} \cr
}
}
\description{
This set of functions assists in validating that the content of
fields coming from REDCap match the MetaData, allowing for a
validation report to provided. The cast helpers allow for transforming
the REDCap data into R data types and allowing the user to customize
the end product.
}
\details{
Functions passed to the \code{na}, \code{validation}, and
\code{cast} parameter of \code{\link[=exportRecordsTyped]{exportRecordsTyped()}} all take the form
of \verb{function(x, coding, field_name)}. \code{na} and \code{validation}
functions are expected to return a logical vector of the same length as the
column processed. Helper routines
are provided here for common cases to construct these functions.
\subsection{Missing Data Detection}{

\code{na_values} is a helper function to create a list of functions
to test for NA based on field type. Useful for bulk override of
NA detection for a project. The output can be directly passed to the \code{na}
parameter of \code{\link[=exportRecordsTyped]{exportRecordsTyped()}}.

Missing data detection is performed ahead of validation. Data that are found
to be missing are excluded from validation reports.

REDCap users may define project-level missing value codes. If such codes
are defined, they can be seen in Project Setup > Additional Customizations >
Missing Data Codes. They will also be displayed in the project's Codebook.
Project-level missing data codes cannot be accessed via the API, meaning
\code{redcapAPI} is unable to assist in determining if a project has any. The
most likely symptom of project-level codes is a high frequency of
values failing validation (See \code{vignette("redcapAPI-missing-data-detection")}).
}

\subsection{Validation Functions}{

\code{isNAorBlank} returns TRUE/FALSE if field is NA or blank. Helper
function for constructing \code{na} overrides in \code{\link[=exportRecordsTyped]{exportRecordsTyped()}}.

\code{valRx} constructs a validation function from a regular expression pattern.
The function returns a TRUE/FALSE if the value matches the pattern.

\code{valChoice} constructs a validation function from a set of choices
defined in the MetaData. The functions returns a TRUE/FALSE if the value
matches one of the choices.

\code{valPhone} constructs a validation function for (North American)
phone numbers. It removes punctuation and spaces prior to validating
with the regular expression.

\code{valSkip} is a function that supports skipping the validation for
a field type. It returns a \code{TRUE} value for each record, regardless
of its value. Validation skipping has occasional utility when importing
certain field types (such as \code{bioportal} or \code{sql}) where not all of the
eventual choices are available in the project yet.

\code{skip_validation} is a list of functions that just returns TRUE for
all data passed in.
}

\subsection{Casting Functions}{

\code{castLabel} constructs a casting function for multiple choice variables.
The field will be cast to return the choice label (generally more human readable).
\code{castLabelCharacter} is an equivalent casting function that returns
a \code{character} vector instead of a \code{factor}.

\code{castCode} constructs a casting function for multiple choice variables.
Similar to \code{castLabel}, but the choice value is returned instead. The
values are typically more compact and their meaning may not be obvious.
\code{castCodeCharacter} is an equivalent casting function that retuns
a \code{character} vector instead of a \code{factor}.

\code{castRaw} constructs a casting function that returns the content
from REDCap as it was received. It is functionally equivalent to \code{identity}.
For multiple choice variables, the result will be coerced to numeric, if possible;
otherwise, the result is character vector.

\code{castChecked} constructs a casting function for checkbox fields. It
returns values in the form of Unchecked/Checked. \code{castCheckedCharacter}
is an equivalent casting function that returns a \code{character} vector
instead of a \code{factor}.

\code{castCheckLabel} and \code{castCheckCode} also construct casting functions
for checkbox fields. For both, unchecked variables are cast to an empty
string (""). Checked variables are cast to the option label and option code,
respectively. \code{castCheckLabelCharacter} and \code{castCheckCodeCharacter}
are equivalent casting functions that returns a \code{character} vector
instead of a \code{factor}.

\code{castCheckForImport} is a special case function to allow the user to
specify exactly which values are to be considered "Checked". Values that
match are returned as \code{1} and all other values are returned as \code{0}. This is
motivated by the special case where the coding on a checkbox includes
"0, Option". In the resulting field \code{checkbox___0}, a coded value
of \code{0} actually implies the choice was selected. In order to perform an
import on such data, it is necessary to cast it using
\code{castCheckForImport(c("0"))}.

\code{castDpNumeric} is a casting function for fields that use the
\code{number_ndp_comma} field type (where \code{n} is the number of
decimal places). This function will convert the values to numeric
values for use in analysis. This is a function that returns the
appropriate casting function, thus the appropriate usage when using
the defaults is \code{cast = list(number_1dp_comma = castDpNumeric())}
(using the parentheses).

\code{castDpCharacter} is a casting function to return fields that use
\code{number_ndp_comma} field types to character strings for import. This
is a function that returns the appropriate casting function, thus the
appropriate usage when casting for one decimal place is
\code{cast = list(number_1dp_comma = castDpCharacter(1))}.

\code{castTimeHHMM} and \code{castTimeMMSS} are casting functions to
facilitate importing data. They convert time data into a character format
that will pass the API requirements.

\code{castLogical} is a casting function that returns a logical vector for
common, binary-type responses. It is well suited to changing true/false,
yes/no, and checkbox fields into logical vectors, as it returns \code{TRUE} if
the value is one of \code{c("1", "true", "yes")} and returns \code{FALSE} otherwise.
}

\subsection{Casting Lists}{

\code{raw_cast} overrides all casting if passed as the \code{cast}
parameter. It is important the the validation specified matches
the chosen cast. For fully raw it should be \code{skip_validation}.

\code{default_cast_no_factor} is a list of casting functions that matches
all of the default casts but with the exception that any fields that would
have been cast to factors will instead be cast to characters. It is
provided for the user that prefers to work absent factors. The list
\code{default_cast_character} is equivalent and is provided for those that
prefer to describe their casting in terms of what the result is (and not
what it is not).
}
}
\examples{
\dontrun{
# Make a custom function to give special treatment to a field.
# In this function, the field "field_name_to_skip" will 
# be cast using `castRaw`. All other fields will be cast 
# using `castCode`
customCastCode <- function(x, field_name, coding){
  if (field_name == "field_name_to_skip"){
    castRaw(x, field_name, coding)
  } else {
    castCode(x, field_name, coding)
  }
}
}

}
\seealso{
\code{\link[=fieldCastingFunctions]{fieldCastingFunctions()}}, \cr
\code{\link[=exportRecordsTyped]{exportRecordsTyped()}}, \cr
\code{\link[=exportReportsTyped]{exportReportsTyped()}}
\subsection{Vignettes}{

\code{vignette("redcapAPI-casting-data")}\cr
\code{vignette("redcapAPI-missing-data-detection")}\cr
\verb{vignette("redcapAPI-data-validation)}\cr
\verb{vignette("redcapAPI-faq)}
}
}
\keyword{datasets}
