% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_bar_chart.R
\name{grouped_bar_chart}
\alias{grouped_bar_chart}
\title{Easy grouped bar charts for categorical variables}
\usage{
grouped_bar_chart(
  data,
  response,
  label = response,
  group = "T1_Group",
  proportion = TRUE,
  print_table = FALSE
)
}
\arguments{
\item{data}{The data frame.}

\item{response}{The categorical dependent variable to be plotted.}

\item{label}{Label of legend describing the dependent variable.}

\item{group}{The group by which to plot the variable}

\item{proportion}{Logical, whether to use proportion (default), else, counts.}

\item{print_table}{Logical, whether to also print the computed proportion or
count table.}
}
\value{
A bar plot of class ggplot.
}
\description{
Make nice grouped bar charts easily.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Make the basic plot
iris2 <- iris
iris2$plant <- c(
  rep("yes", 45),
  rep("no", 45),
  rep("maybe", 30),
  rep("NA", 30)
)
grouped_bar_chart(
  data = iris2,
  response = "plant",
  group = "Species"
)
\dontshow{\}) # examplesIf}
}
