% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_data2codelist.R
\name{ru_data2codelist}
\alias{ru_data2codelist}
\title{Return a list with codelist, code and label based on input codelist dataset.}
\usage{
ru_data2codelist(
  dsetin,
  codelistvarname = "FMTNAME",
  codevarname = "START",
  decodevarname = "LABEL",
  typevarname = "TYPE"
)
}
\arguments{
\item{dsetin}{Name of incoming data set structured as a SAS format catalog saved as a data set.}

\item{codelistvarname}{Name of the variable containing the SAS format or similar.}

\item{codevarname}{Name of the variable that holds the code value.}

\item{decodevarname}{Name of the variable that holds the decode value.}

\item{typevarname}{Type of format (character or numeric).}
}
\value{
A list based on the incoming data frame but with decode values added along with records when completetypes is true.
}
\description{
Pass in a data set from a SAS format catalog (or similar) and have a list returned in the structure of a SAS format for decoding variables.
}
\examples{
library(repfun)
datdir <- file.path(gsub("\\\\","/",tempdir(),fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
rfenv <- repfun::rs_setup(R_RFMTDIR=datdir,RetEnv=TRUE)
list <- repfun::ru_data2codelist(rfenv$rfmtdata$formats.rda())
list$SEXS$START[[1]] # Code value 1
list$SEXS$LABEL[[1]] # Decode value 1
list$SEXS$START[[2]] # Code value 2
list$SEXS$LABEL[[2]] # Decode value 2
}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
