% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{detectActiveCores}
\alias{detectActiveCores}
\title{Count Active Threads Based on CPU Usage}
\usage{
detectActiveCores(pattern = "", minCPU = 50)
}
\arguments{
\item{pattern}{A character string used to filter process lines. Only
processes whose command line matches this pattern will be considered.
Default is \code{""} (matches all).}

\item{minCPU}{A numeric value specifying the minimum CPU usage (in percent)
for a process to be considered active. Default is \code{50}.}
}
\value{
An integer representing the number of active threads matching the
pattern and exceeding the CPU usage threshold. Returns \code{NULL} with a
message if run on Windows.
}
\description{
This function counts the number of active system processes (threads) that
match a given pattern and exceed a specified minimum CPU usage threshold. It
works on Unix-like systems (e.g., Linux, macOS) and does not support Windows.
}
\note{
This function uses the \code{ps -ef} system command and regular expressions
to parse CPU usage. It may not be portable across all Unix variants.
}
\examples{
\dontrun{
  detectActiveCores(pattern = "R", minCPU = 30)
}

}
