% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chek_reptiledb_status.R
\name{check_data_update}
\alias{check_data_update}
\title{Check if reptile database data needs updating}
\usage{
check_data_update(
  version_date = "2025-09-01",
  silent = FALSE,
  check_connection = TRUE
)
}
\arguments{
\item{version_date}{Character string indicating the most recent date of the data source.}

\item{silent}{Logical. If TRUE, suppresses all messages and returns only the
result object. Default is FALSE.}

\item{check_connection}{Logical. If TRUE, verifies internet connection before
attempting to check for updates. Default is TRUE.}
}
\value{
An S3 object of class "reptile_update_check" with the following components:
\describe{
\item{needs_update}{Logical. TRUE if update is available}
\item{local_date}{Date. Version date of local data}
\item{remote_date}{Date. Version date of remote data (if available)}
\item{days_behind}{Integer. Days between local and remote versions}
\item{download_url}{Character. URL to download latest data}
\item{status}{Character. One of "current", "outdated", "newer", "unknown", "no_connection"}
}
}
\description{
Compares the local reptile database version with the latest available
version on The Reptile Database website and provides user-friendly feedback.
}
\examples{
\donttest{
# Check with user-friendly messages
check_data_update()

# Silent check for programmatic use
result <- check_data_update(silent = TRUE)
if (result$needs_update) {
  message("Update available!")
}
}

}
