% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{calBPtoBCAD}
\alias{calBPtoBCAD}
\title{calculate cal BC/AD ages from cal BP ages}
\usage{
calBPtoBCAD(x, zero = FALSE)
}
\arguments{
\item{x}{The calBP age(s) to be translated into cal BC/AD ages.}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to \code{zero=FALSE}.}
}
\value{
The cal BC/AD age(s). BC ages are negative, AD ages are positive.
}
\description{
calculate cal BC/AD ages from cal BP ages
}
\details{
Turn cal BP ages into cal BC/AD (equivalent to cal BCE/CE). Negative ages indicate cal BC, positive ages cal AD. Since the Gregorian and Julian calendars do not include 0 BCAD (i.e., 31 December of 1 BC is followed by 1 January of AD 1), zero can be omitted. The years then go from -1 (i.e., 1 BC) to 1 AD. Other calendars, such as the astronomical one, do include zero.
}
\examples{
 calBPtoBCAD(2024)
 calBPtoBCAD(1945:1955, zero=FALSE)
 calBPtoBCAD(1945:1955, zero=TRUE)
}
