% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_comp_pair}
\alias{comp_comp_pair}
\title{Compute a probability's (missing) complement and return both.}
\usage{
comp_comp_pair(p1 = NA, p2 = NA)
}
\arguments{
\item{p1}{A numeric probability value
(in range from 0 to 1).
\code{p1} is optional when \code{p2} is provided.}

\item{p2}{A numeric probability value
(in range from 0 to 1).
\code{p2} is optional when \code{p1} is provided.}
}
\value{
A vector \code{v} containing 2 numeric probability values
(in range from 0 to 1): \code{v = c(p1, p2)}.
}
\description{
\code{comp_comp_pair} is a function that takes 0, 1, or 2
probabilities (\code{p1} and \code{p2}) as inputs.
If either of them is missing (\code{NA}), it computes the complement
of the other one and returns both probabilities.
}
\details{
\code{comp_comp_pair} does \emph{nothing} when both arguments are provided
(i.e., \code{!is.na(p1) & !is.na(p2)}) and only issues
a warning if both arguments are missing
(i.e., \code{is.na(p1) & is.na(p2)}).

Inputs are \emph{not} verified:
Use \code{\link{is_prob}} to verify that an input is
a probability and \code{\link{is_complement}} to verify
that two provided values actually are complements.
}
\examples{
# ways to work:
comp_comp_pair(1, 0)   # => 1 0
comp_comp_pair(0, 1)   # => 0 1
comp_comp_pair(1, NA)  # => 1 0
comp_comp_pair(NA, 1)  # => 0 1

# watch out for:
comp_comp_pair(NA, NA) # => NA NA + warning
comp_comp_pair(8, 8)   # => 8 8 + NO warning (as is_prob is not verified)
comp_comp_pair(1, 1)   # => 1 1 + NO warning (as is_complement is not verified)

}
\seealso{
\code{\link{is_complement}} verifies numeric complements;
\code{\link{is_valid_prob_set}} verifies sets of probabilities;
\code{\link{comp_complete_prob_set}} completes valid sets of probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: 
\code{\link{comp_FDR}()},
\code{\link{comp_FOR}()},
\code{\link{comp_NPV}()},
\code{\link{comp_PPV}()},
\code{\link{comp_acc}()},
\code{\link{comp_accu_freq}()},
\code{\link{comp_accu_prob}()},
\code{\link{comp_complement}()},
\code{\link{comp_complete_prob_set}()},
\code{\link{comp_err}()},
\code{\link{comp_fart}()},
\code{\link{comp_mirt}()},
\code{\link{comp_ppod}()},
\code{\link{comp_prob}()},
\code{\link{comp_prob_freq}()},
\code{\link{comp_sens}()},
\code{\link{comp_spec}()}
}
\concept{functions computing probabilities}
