% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_copy.R
\name{rxp_copy}
\alias{rxp_copy}
\title{Copy Derivations From the Nix Store to Current Working Directory}
\usage{
rxp_copy(derivation_name = NULL, dir_mode = "0755", file_mode = "0644")
}
\arguments{
\item{derivation_name}{The name of the derivation to copy. If empty, then all
the derivations are copied.}

\item{dir_mode}{Character, default "0755". POSIX permission mode to apply to
directories under the copied output (including the top-level output
directory).}

\item{file_mode}{Character, default "0644". POSIX permission mode to apply to
files under the copied output.}
}
\value{
Nothing, the contents of the Nix store are copied to the current
working directory.
}
\description{
When Nix builds a derivation, its output is saved in the
Nix store located under \verb{/nix/store/}. Even though you can import the
derivations into the current R session using \code{rxp_read()} or \code{rxp_load()},
it can be useful to copy the outputs to the current working directory. This
is especially useful for Quarto documents, where there can be more than one
input, as is the case for \code{html} output.
}
\examples{
\dontrun{
  # Copy all derivations to the current working directory
  rxp_copy()

  # Copy a specific derivation
  rxp_copy("mtcars")

  # Copy with custom permissions (e.g., make scripts executable)
  rxp_copy("my_deriv", dir_mode = "0755", file_mode = "0644")

  # Copy a Quarto document output with multiple files
  rxp_copy("my_quarto_doc")
}
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_check_chronicles}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_list_logs}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
