/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import ec.util.spreadsheet.Sheet;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxDateSystem;
import spreadsheet.xlsx.XlsxSheetBuilder;
import spreadsheet.xlsx.internal.DefaultSheetBuilder;
import spreadsheet.xlsx.internal.XlsxValueFactory;

public final class DisruptorSheetBuilder
implements XlsxSheetBuilder {
    private final DefaultSheetBuilder delegate;
    private final Disruptor<CustomEvent> disruptor;
    private final RingBuffer<CustomEvent> ringBuffer;

    public static DisruptorSheetBuilder of(XlsxDateSystem dateSystem, List<String> sharedStrings, boolean[] dateFormats) {
        return new DisruptorSheetBuilder(DefaultSheetBuilder.of(dateSystem, sharedStrings, dateFormats));
    }

    private DisruptorSheetBuilder(DefaultSheetBuilder delegate) {
        this.delegate = delegate;
        this.disruptor = new Disruptor(() -> new CustomEvent(), 1024, (ThreadFactory)DaemonThreadFactory.INSTANCE, ProducerType.SINGLE, (WaitStrategy)new YieldingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{this::handleEvent});
        this.ringBuffer = this.disruptor.start();
    }

    private void handleEvent(CustomEvent event, long sequence, boolean endOfBatch) {
        this.delegate.put(event.ref, event.value, XlsxValueFactory.getDataTypeByOrdinal(event.dataType), event.styleIndex);
    }

    @Override
    public XlsxSheetBuilder reset(String sheetName, String sheetBounds) {
        this.waitForCompletion();
        this.delegate.reset(sheetName, sheetBounds);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XlsxSheetBuilder put(String ref, CharSequence value, XlsxDataType dataType, int styleIndex) {
        long sequence = this.ringBuffer.next();
        try {
            CustomEvent event = (CustomEvent)this.ringBuffer.get(sequence);
            event.ref = ref;
            event.value = value;
            event.dataType = dataType.ordinal();
            event.styleIndex = styleIndex;
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
        return this;
    }

    @Override
    public Sheet build() {
        this.waitForCompletion();
        return this.delegate.build();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        this.disruptor.halt();
    }

    private void waitForCompletion() {
        while (this.ringBuffer.getCursor() - this.ringBuffer.getMinimumGatingSequence() != 0L) {
        }
    }

    private static final class CustomEvent {
        private String ref;
        private CharSequence value;
        private int dataType;
        private int styleIndex;

        private CustomEvent() {
        }
    }
}

