/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.roots;

import internal.toolkit.base.core.math.functions.gsl.roots.FDFSolver;
import internal.toolkit.base.core.math.functions.gsl.roots.GslRootException;
import java.util.function.DoubleUnaryOperator;

public class SteffensonSolver
extends FDFSolver {
    private double x;
    private double x1 = 0.0;
    private double x2 = 0.0;
    private int count = 1;

    public SteffensonSolver(DoubleUnaryOperator fn, DoubleUnaryOperator dfn, double root) {
        this.function = fn;
        this.functionDf = dfn;
        this.root = root;
        this.f = fn.applyAsDouble(root);
        this.df = dfn.applyAsDouble(root);
        this.x = root;
    }

    @Override
    public void iterate() {
        double x = this.x;
        double x1 = this.x1;
        if (this.df == 0.0) {
            throw new GslRootException("Derivative is zero");
        }
        double x_new = x - this.f / this.df;
        double f_new = this.function.applyAsDouble(x_new);
        double df_new = this.functionDf.applyAsDouble(x_new);
        this.x2 = x1;
        this.x1 = x;
        this.x = x_new;
        this.f = f_new;
        this.df = df_new;
        if (!Double.isFinite(f_new)) {
            throw new GslRootException("Function value is not finite");
        }
        if (this.count < 3) {
            this.root = x_new;
            ++this.count;
        } else {
            double u = x - x1;
            double v = x_new - 2.0 * x + x1;
            this.root = v == 0.0 ? x_new : x1 - u * u / v;
        }
    }
}

