/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.riso;

import internal.toolkit.base.core.math.functions.riso.Mcsrch;

public class Lbfgs {
    public double gtol = 0.9;
    public double stpmin = 1.0E-20;
    public double stpmax = 1.0E20;
    public double[] solution_cache = null;
    private IFeedBack feedback_;
    private double gnorm = 0.0;
    private double stp1 = 0.0;
    private double ftol = 0.0;
    private double[] stp = new double[1];
    private double ys = 0.0;
    private double yy = 0.0;
    private double sq = 0.0;
    private double yr = 0.0;
    private double beta = 0.0;
    private double xnorm = 0.0;
    private int iter = 0;
    private int nfun = 0;
    private int point = 0;
    private int ispt = 0;
    private int iypt = 0;
    private int maxfev = 0;
    private int[] info = new int[1];
    private int bound = 0;
    private int npt = 0;
    private int cp = 0;
    private int i = 0;
    private int[] nfev = new int[1];
    private int inmc = 0;
    private int iycn = 0;
    private int iscn = 0;
    private boolean finish = false;
    private double[] w = null;
    private final Mcsrch mcsrch = new Mcsrch();

    public static void daxpy(int n, double da, double[] dx, int ix0, int incx, double[] dy, int iy0, int incy) {
        int mp1;
        int i;
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                dy[iy0 + iy - 1] = dy[iy0 + iy - 1] + da * dx[ix0 + ix - 1];
                ix += incx;
                iy += incy;
            }
            return;
        }
        int m = n % 4;
        if (m != 0) {
            for (i = 1; i <= m; ++i) {
                dy[iy0 + i - 1] = dy[iy0 + i - 1] + da * dx[ix0 + i - 1];
            }
            if (n < 4) {
                return;
            }
        }
        for (i = mp1 = m + 1; i <= n; i += 4) {
            dy[iy0 + i - 1] = dy[iy0 + i - 1] + da * dx[ix0 + i - 1];
            dy[iy0 + i + 1 - 1] = dy[iy0 + i + 1 - 1] + da * dx[ix0 + i + 1 - 1];
            dy[iy0 + i + 2 - 1] = dy[iy0 + i + 2 - 1] + da * dx[ix0 + i + 2 - 1];
            dy[iy0 + i + 3 - 1] = dy[iy0 + i + 3 - 1] + da * dx[ix0 + i + 3 - 1];
        }
    }

    public static double ddot(int n, double[] dx, int ix0, int incx, double[] dy, int iy0, int incy) {
        int mp1;
        int i;
        double dtemp = 0.0;
        if (n <= 0) {
            return 0.0;
        }
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                dtemp += dx[ix0 + ix - 1] * dy[iy0 + iy - 1];
                ix += incx;
                iy += incy;
            }
            return dtemp;
        }
        int m = n % 5;
        if (m != 0) {
            for (i = 1; i <= m; ++i) {
                dtemp += dx[ix0 + i - 1] * dy[iy0 + i - 1];
            }
            if (n < 5) {
                return dtemp;
            }
        }
        for (i = mp1 = m + 1; i <= n; i += 5) {
            dtemp = dtemp + dx[ix0 + i - 1] * dy[iy0 + i - 1] + dx[ix0 + i + 1 - 1] * dy[iy0 + i + 1 - 1] + dx[ix0 + i + 2 - 1] * dy[iy0 + i + 2 - 1] + dx[ix0 + i + 3 - 1] * dy[iy0 + i + 3 - 1] + dx[ix0 + i + 4 - 1] * dy[iy0 + i + 4 - 1];
        }
        return dtemp;
    }

    public int getNIter() {
        return this.iter;
    }

    public int getFunctionEvaluationCount() {
        return this.nfun;
    }

    IFeedBack getFeedBack() {
        return this.feedback_;
    }

    void setFeedBack(IFeedBack fb) {
        this.feedback_ = fb;
    }

    public void lbfgs(int n, int m, double[] x, double f, double[] g, boolean diagco, double[] diag, int[] iprint, double eps, double xtol, int[] iflag) throws ExceptionWithIflag {
        boolean execute_entire_while_loop = false;
        if (this.w == null || this.w.length != n * (2 * m + 1) + 2 * m) {
            this.w = new double[n * (2 * m + 1) + 2 * m];
        }
        if (iflag[0] == 0) {
            this.solution_cache = new double[n];
            System.arraycopy(x, 0, this.solution_cache, 0, n);
            this.iter = 0;
            if (n <= 0 || m <= 0) {
                iflag[0] = -3;
                throw new ExceptionWithIflag(iflag[0], "Improper input parameters  (n or m are not positive.)");
            }
            if (this.gtol <= 1.0E-4) {
                this.gtol = 0.9;
            }
            this.nfun = 1;
            this.point = 0;
            this.finish = false;
            if (diagco) {
                this.i = 1;
                while (this.i <= n) {
                    if (diag[this.i - 1] <= 0.0) {
                        iflag[0] = -2;
                        throw new ExceptionWithIflag(iflag[0], "The " + this.i + "-th diagonal element of the inverse hessian approximation is not positive.");
                    }
                    ++this.i;
                }
            } else {
                this.i = 1;
                while (this.i <= n) {
                    diag[this.i - 1] = 1.0;
                    ++this.i;
                }
            }
            this.ispt = n + 2 * m;
            this.iypt = this.ispt + n * m;
            this.i = 1;
            while (this.i <= n) {
                this.w[this.ispt + this.i - 1] = -g[this.i - 1] * diag[this.i - 1];
                ++this.i;
            }
            this.gnorm = Math.sqrt(Lbfgs.ddot(n, g, 0, 1, g, 0, 1));
            this.stp1 = 1.0 / this.gnorm;
            this.ftol = 1.0E-4;
            this.maxfev = 20;
            if (this.feedback_ != null) {
                this.feedback_.show(this.iter, x, f, g);
            }
            execute_entire_while_loop = true;
        }
        while (true) {
            if (execute_entire_while_loop) {
                ++this.iter;
                this.info[0] = 0;
                this.bound = this.iter - 1;
                if (this.iter != 1) {
                    if (this.iter > m) {
                        this.bound = m;
                    }
                    this.ys = Lbfgs.ddot(n, this.w, this.iypt + this.npt, 1, this.w, this.ispt + this.npt, 1);
                    if (!diagco) {
                        this.yy = Lbfgs.ddot(n, this.w, this.iypt + this.npt, 1, this.w, this.iypt + this.npt, 1);
                        this.i = 1;
                        while (this.i <= n) {
                            diag[this.i - 1] = this.ys / this.yy;
                            ++this.i;
                        }
                    } else {
                        iflag[0] = 2;
                        return;
                    }
                }
            }
            if (execute_entire_while_loop || iflag[0] == 2) {
                if (this.iter != 1) {
                    if (diagco) {
                        this.i = 1;
                        while (this.i <= n) {
                            if (diag[this.i - 1] <= 0.0) {
                                iflag[0] = -2;
                                throw new ExceptionWithIflag(iflag[0], "The " + this.i + "-th diagonal element of the inverse hessian approximation is not positive.");
                            }
                            ++this.i;
                        }
                    }
                    this.cp = this.point;
                    if (this.point == 0) {
                        this.cp = m;
                    }
                    this.w[n + this.cp - 1] = 1.0 / this.ys;
                    this.i = 1;
                    while (this.i <= n) {
                        this.w[this.i - 1] = -g[this.i - 1];
                        ++this.i;
                    }
                    this.cp = this.point;
                    this.i = 1;
                    while (this.i <= this.bound) {
                        --this.cp;
                        if (this.cp == -1) {
                            this.cp = m - 1;
                        }
                        this.sq = Lbfgs.ddot(n, this.w, this.ispt + this.cp * n, 1, this.w, 0, 1);
                        this.inmc = n + m + this.cp + 1;
                        this.iycn = this.iypt + this.cp * n;
                        this.w[this.inmc - 1] = this.w[n + this.cp + 1 - 1] * this.sq;
                        Lbfgs.daxpy(n, -this.w[this.inmc - 1], this.w, this.iycn, 1, this.w, 0, 1);
                        ++this.i;
                    }
                    this.i = 1;
                    while (this.i <= n) {
                        this.w[this.i - 1] = diag[this.i - 1] * this.w[this.i - 1];
                        ++this.i;
                    }
                    this.i = 1;
                    while (this.i <= this.bound) {
                        this.yr = Lbfgs.ddot(n, this.w, this.iypt + this.cp * n, 1, this.w, 0, 1);
                        this.beta = this.w[n + this.cp + 1 - 1] * this.yr;
                        this.inmc = n + m + this.cp + 1;
                        this.beta = this.w[this.inmc - 1] - this.beta;
                        this.iscn = this.ispt + this.cp * n;
                        Lbfgs.daxpy(n, this.beta, this.w, this.iscn, 1, this.w, 0, 1);
                        ++this.cp;
                        if (this.cp == m) {
                            this.cp = 0;
                        }
                        ++this.i;
                    }
                    this.i = 1;
                    while (this.i <= n) {
                        this.w[this.ispt + this.point * n + this.i - 1] = this.w[this.i - 1];
                        ++this.i;
                    }
                }
                this.nfev[0] = 0;
                this.stp[0] = 1.0;
                if (this.iter == 1) {
                    this.stp[0] = this.stp1;
                }
                this.i = 1;
                while (this.i <= n) {
                    this.w[this.i - 1] = g[this.i - 1];
                    ++this.i;
                }
            }
            this.mcsrch.fn(this, n, x, f, g, this.w, this.ispt + this.point * n, this.stp, this.ftol, xtol, this.maxfev, this.info, this.nfev, diag);
            if (this.info[0] == -1) {
                iflag[0] = 1;
                return;
            }
            if (this.info[0] != 1) {
                iflag[0] = -1;
                return;
            }
            this.nfun += this.nfev[0];
            this.npt = this.point * n;
            this.i = 1;
            while (this.i <= n) {
                this.w[this.ispt + this.npt + this.i - 1] = this.stp[0] * this.w[this.ispt + this.npt + this.i - 1];
                this.w[this.iypt + this.npt + this.i - 1] = g[this.i - 1] - this.w[this.i - 1];
                ++this.i;
            }
            ++this.point;
            if (this.point == m) {
                this.point = 0;
            }
            this.gnorm = Math.sqrt(Lbfgs.ddot(n, g, 0, 1, g, 0, 1));
            this.xnorm = Math.sqrt(Lbfgs.ddot(n, x, 0, 1, x, 0, 1));
            this.xnorm = Math.max(1.0, this.xnorm);
            if (this.gnorm / this.xnorm <= eps) {
                this.finish = true;
            }
            if (this.feedback_ != null) {
                this.feedback_.show(this.iter, x, f, g);
            }
            System.arraycopy(x, 0, this.solution_cache, 0, n);
            if (this.finish) {
                iflag[0] = 0;
                return;
            }
            execute_entire_while_loop = true;
        }
    }

    public int nfevaluations() {
        return this.nfun;
    }

    static interface IFeedBack {
        public void show(int var1, double[] var2, double var3, double[] var5);
    }

    public static class ExceptionWithIflag
    extends RuntimeException {
        private static final long serialVersionUID = 5461445734151348525L;
        public int iflag;

        public ExceptionWithIflag(int i, String s) {
            super(s);
            this.iflag = i;
        }

        @Override
        public String toString() {
            return this.getMessage() + " (iflag == " + this.iflag + ")";
        }
    }
}

