/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.riso;

import internal.toolkit.base.core.math.functions.riso.Lbfgs;

public class Mcsrch {
    private int[] infoc = new int[1];
    private int j = 0;
    private double dg = 0.0;
    private double dgm = 0.0;
    private double dginit = 0.0;
    private double dgtest = 0.0;
    private double[] dgx = new double[1];
    private double[] dgxm = new double[1];
    private double[] dgy = new double[1];
    private double[] dgym = new double[1];
    private double finit = 0.0;
    private double ftest1 = 0.0;
    private double fm = 0.0;
    private double[] fx = new double[1];
    private double[] fxm = new double[1];
    private double[] fy = new double[1];
    private double[] fym = new double[1];
    private double p5 = 0.0;
    private double p66 = 0.0;
    private double[] stx = new double[1];
    private double[] sty = new double[1];
    private double stmin = 0.0;
    private double stmax = 0.0;
    private double width = 0.0;
    private double width1 = 0.0;
    private double xtrapf = 0.0;
    private boolean[] brackt = new boolean[1];
    private boolean stage1 = false;

    static double max3(double x, double y, double z) {
        return x < y ? (y < z ? z : y) : (x < z ? z : x);
    }

    public static void mcstep(double[] stx, double[] fx, double[] dx, double[] sty, double[] fy, double[] dy, double[] stp, double fp, double dp, boolean[] brackt, double stpmin, double stpmax, int[] info) {
        double stpf;
        boolean bound;
        info[0] = 0;
        if (brackt[0] && (stp[0] <= Math.min(stx[0], sty[0]) || stp[0] >= Math.max(stx[0], sty[0])) || dx[0] * (stp[0] - stx[0]) >= 0.0 || stpmax < stpmin) {
            return;
        }
        double sgnd = dp * (dx[0] / Math.abs(dx[0]));
        if (fp == Double.MAX_VALUE) {
            fp = Math.sqrt(fp);
        }
        if (fp > fx[0]) {
            info[0] = 1;
            bound = true;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s));
            if (stp[0] < stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dx[0] + theta;
            double q = gamma - dx[0] + gamma + dp;
            double r = p / q;
            double stpc = stx[0] + r * (stp[0] - stx[0]);
            double stpq = stx[0] + dx[0] / ((fx[0] - fp) / (stp[0] - stx[0]) + dx[0]) / 2.0 * (stp[0] - stx[0]);
            stpf = Math.abs(stpc - stx[0]) < Math.abs(stpq - stx[0]) ? stpc : stpc + (stpq - stpc) / 2.0;
            brackt[0] = true;
        } else if (sgnd < 0.0) {
            info[0] = 2;
            bound = false;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dp + theta;
            double q = gamma - dp + gamma + dx[0];
            double r = p / q;
            double stpc = stp[0] + r * (stx[0] - stp[0]);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            stpf = Math.abs(stpc - stp[0]) > Math.abs(stpq - stp[0]) ? stpc : stpq;
            brackt[0] = true;
        } else if (Math.abs(dp) < Math.abs(dx[0])) {
            double q;
            double p;
            double r;
            info[0] = 3;
            bound = true;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Math.max(0.0, Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s)));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double stpc = (r = (p = gamma - dp + theta) / (q = gamma + (dx[0] - dp) + gamma)) < 0.0 && gamma != 0.0 ? stp[0] + r * (stx[0] - stp[0]) : (stp[0] > stx[0] ? stpmax : stpmin);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            stpf = brackt[0] ? (Math.abs(stp[0] - stpc) < Math.abs(stp[0] - stpq) ? stpc : stpq) : (Math.abs(stp[0] - stpc) > Math.abs(stp[0] - stpq) ? stpc : stpq);
        } else {
            info[0] = 4;
            bound = false;
            if (brackt[0]) {
                double stpc;
                double theta = 3.0 * (fp - fy[0]) / (sty[0] - stp[0]) + dy[0] + dp;
                double s = Mcsrch.max3(Math.abs(theta), Math.abs(dy[0]), Math.abs(dp));
                double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dy[0] / s * (dp / s));
                if (stp[0] > sty[0]) {
                    gamma = -gamma;
                }
                double p = gamma - dp + theta;
                double q = gamma - dp + gamma + dy[0];
                double r = p / q;
                stpf = stpc = stp[0] + r * (sty[0] - stp[0]);
            } else {
                stpf = stp[0] > stx[0] ? stpmax : stpmin;
            }
        }
        if (fp > fx[0]) {
            sty[0] = stp[0];
            fy[0] = fp;
            dy[0] = dp;
        } else {
            if (sgnd < 0.0) {
                sty[0] = stx[0];
                fy[0] = fx[0];
                dy[0] = dx[0];
            }
            stx[0] = stp[0];
            fx[0] = fp;
            dx[0] = dp;
        }
        stpf = Math.min(stpmax, stpf);
        stp[0] = stpf = Math.max(stpmin, stpf);
        if (brackt[0] && bound) {
            stp[0] = sty[0] > stx[0] ? Math.min(stx[0] + 0.66 * (sty[0] - stx[0]), stp[0]) : Math.max(stx[0] + 0.66 * (sty[0] - stx[0]), stp[0]);
        }
    }

    static double sqr(double x) {
        return x * x;
    }

    public void fn(Lbfgs lbfgs, int n, double[] x, double f, double[] g, double[] s, int is0, double[] stp, double ftol, double xtol, int maxfev, int[] info, int[] nfev, double[] wa) {
        this.p5 = 0.5;
        this.p66 = 0.66;
        this.xtrapf = 4.0;
        if (info[0] != -1) {
            this.infoc[0] = 1;
            if (n <= 0 || stp[0] <= 0.0 || ftol < 0.0 || lbfgs.gtol < 0.0 || xtol < 0.0 || lbfgs.stpmin < 0.0 || lbfgs.stpmax < lbfgs.stpmin || maxfev <= 0) {
                return;
            }
            this.dginit = 0.0;
            this.j = 1;
            while (this.j <= n) {
                this.dginit += g[this.j - 1] * s[is0 + this.j - 1];
                ++this.j;
            }
            if (this.dginit >= 0.0) {
                System.out.println("The search direction is not a descent direction.");
                return;
            }
            this.brackt[0] = false;
            this.stage1 = true;
            nfev[0] = 0;
            this.finit = f;
            this.dgtest = ftol * this.dginit;
            this.width = lbfgs.stpmax - lbfgs.stpmin;
            this.width1 = this.width / this.p5;
            this.j = 1;
            while (this.j <= n) {
                wa[this.j - 1] = x[this.j - 1];
                ++this.j;
            }
            this.stx[0] = 0.0;
            this.fx[0] = this.finit;
            this.dgx[0] = this.dginit;
            this.sty[0] = 0.0;
            this.fy[0] = this.finit;
            this.dgy[0] = this.dginit;
        }
        while (true) {
            if (info[0] != -1) {
                if (this.brackt[0]) {
                    this.stmin = Math.min(this.stx[0], this.sty[0]);
                    this.stmax = Math.max(this.stx[0], this.sty[0]);
                } else {
                    this.stmin = this.stx[0];
                    this.stmax = stp[0] + this.xtrapf * (stp[0] - this.stx[0]);
                }
                stp[0] = Math.max(stp[0], lbfgs.stpmin);
                stp[0] = Math.min(stp[0], lbfgs.stpmax);
                if (this.brackt[0] && (stp[0] <= this.stmin || stp[0] >= this.stmax) || nfev[0] >= maxfev - 1 || this.infoc[0] == 0 || this.brackt[0] && this.stmax - this.stmin <= xtol * this.stmax) {
                    stp[0] = this.stx[0];
                }
                this.j = 1;
                while (this.j <= n) {
                    x[this.j - 1] = wa[this.j - 1] + stp[0] * s[is0 + this.j - 1];
                    ++this.j;
                }
                info[0] = -1;
                return;
            }
            info[0] = 0;
            nfev[0] = nfev[0] + 1;
            this.dg = 0.0;
            this.j = 1;
            while (this.j <= n) {
                this.dg += g[this.j - 1] * s[is0 + this.j - 1];
                ++this.j;
            }
            this.ftest1 = this.finit + stp[0] * this.dgtest;
            if (this.brackt[0] && (stp[0] <= this.stmin || stp[0] >= this.stmax) || this.infoc[0] == 0) {
                info[0] = 6;
            }
            if (stp[0] == lbfgs.stpmax && f <= this.ftest1 && this.dg <= this.dgtest) {
                info[0] = 5;
            }
            if (stp[0] == lbfgs.stpmin && (f > this.ftest1 || this.dg >= this.dgtest)) {
                info[0] = 4;
            }
            if (nfev[0] >= maxfev) {
                info[0] = 3;
            }
            if (this.brackt[0] && this.stmax - this.stmin <= xtol * this.stmax) {
                info[0] = 2;
            }
            if (f <= this.ftest1 && Math.abs(this.dg) <= lbfgs.gtol * -this.dginit) {
                info[0] = 1;
            }
            if (info[0] != 0) {
                return;
            }
            if (this.stage1 && f <= this.ftest1 && this.dg >= Math.min(ftol, lbfgs.gtol) * this.dginit) {
                this.stage1 = false;
            }
            if (this.stage1 && f <= this.fx[0] && f > this.ftest1) {
                this.fm = f - stp[0] * this.dgtest;
                this.fxm[0] = this.fx[0] - this.stx[0] * this.dgtest;
                this.fym[0] = this.fy[0] - this.sty[0] * this.dgtest;
                this.dgm = this.dg - this.dgtest;
                this.dgxm[0] = this.dgx[0] - this.dgtest;
                this.dgym[0] = this.dgy[0] - this.dgtest;
                Mcsrch.mcstep(this.stx, this.fxm, this.dgxm, this.sty, this.fym, this.dgym, stp, this.fm, this.dgm, this.brackt, this.stmin, this.stmax, this.infoc);
                this.fx[0] = this.fxm[0] + this.stx[0] * this.dgtest;
                this.fy[0] = this.fym[0] + this.sty[0] * this.dgtest;
                this.dgx[0] = this.dgxm[0] + this.dgtest;
                this.dgy[0] = this.dgym[0] + this.dgtest;
            } else {
                Mcsrch.mcstep(this.stx, this.fx, this.dgx, this.sty, this.fy, this.dgy, stp, f, this.dg, this.brackt, this.stmin, this.stmax, this.infoc);
            }
            if (!this.brackt[0]) continue;
            if (Math.abs(this.sty[0] - this.stx[0]) >= this.p66 * this.width1) {
                stp[0] = this.stx[0] + this.p5 * (this.sty[0] - this.stx[0]);
            }
            this.width1 = this.width;
            this.width = Math.abs(this.sty[0] - this.stx[0]);
        }
    }
}

