/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import jdplus.toolkit.base.api.data.ParameterType;

@Deprecated
public final class OldParameter
implements Cloneable,
Comparable<OldParameter> {
    private double value;
    private ParameterType type;
    private static final String EMPTY = "";

    public static OldParameter[] clone(OldParameter[] value) {
        if (value == null) {
            return null;
        }
        OldParameter[] p = new OldParameter[value.length];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) continue;
            p[i] = value[i].clone();
        }
        return p;
    }

    public static OldParameter clone(OldParameter p) {
        return p == null ? null : p.clone();
    }

    public static OldParameter[] create(int n) {
        if (n == 0) {
            return null;
        }
        OldParameter[] p = new OldParameter[n];
        for (int i = 0; i < n; ++i) {
            p[i] = new OldParameter();
        }
        return p;
    }

    public static boolean hasFixedParameters(OldParameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type != ParameterType.Fixed) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFreeParameters(OldParameter[] p) {
        if (p == null) {
            return false;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type == ParameterType.Fixed) continue;
            return true;
        }
        return false;
    }

    public static int countFixedParameters(OldParameter[] p) {
        if (p == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type != ParameterType.Fixed) continue;
            ++n;
        }
        return n;
    }

    public static int countFreeParameters(OldParameter[] p) {
        if (p == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type == ParameterType.Fixed) continue;
            ++n;
        }
        return n;
    }

    public static boolean isDefault(OldParameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].type == ParameterType.Undefined) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefault(OldParameter p) {
        if (p == null) {
            return true;
        }
        return p.type == ParameterType.Undefined;
    }

    public static boolean isDefined(OldParameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] != null && p[i].type != ParameterType.Undefined) continue;
            return false;
        }
        return true;
    }

    public static boolean isDefined(OldParameter p) {
        return p != null && p.type != ParameterType.Undefined;
    }

    public static boolean isZero(OldParameter[] p) {
        if (p == null) {
            return true;
        }
        for (int i = 0; i < p.length; ++i) {
            if (p[i] == null || p[i].value == 0.0) continue;
            return false;
        }
        return true;
    }

    public OldParameter() {
        this.type = ParameterType.Undefined;
    }

    public OldParameter(double value, ParameterType type) {
        this.type = type;
        this.value = value;
    }

    public OldParameter clone() {
        try {
            return (OldParameter)super.clone();
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void copy(OldParameter mu) {
        this.value = mu.value;
        this.type = mu.type;
    }

    @Override
    public int compareTo(OldParameter p) {
        int r = Double.compare(this.value, p.value);
        if (r != 0) {
            return r;
        }
        return this.type.compareTo((Enum)p.type);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OldParameter && this.equals((OldParameter)obj);
    }

    public boolean equals(OldParameter other) {
        return this.value == other.value && this.type == other.type;
    }

    public ParameterType getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Double.hashCode(this.value);
        hash = 59 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public void setType(ParameterType value) {
        this.type = value;
        if (this.type == ParameterType.Undefined) {
            this.value = 0.0;
        }
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean isFixed() {
        return this.type == ParameterType.Fixed;
    }

    public String toString() {
        return this.toString("%4g");
    }

    public String toString(String fmt) {
        if (this.type == ParameterType.Undefined) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(new Formatter(Locale.ROOT).format(fmt, this.value).toString());
        if (this.type == ParameterType.Fixed) {
            builder.append('f');
        }
        return builder.toString();
    }
}

