/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.accumulator;

import java.math.BigDecimal;
import java.math.MathContext;
import jdplus.toolkit.base.core.data.accumulator.DoubleAccumulator;

public class BigDecimalAccumulator
implements DoubleAccumulator {
    private BigDecimal sum;
    private final MathContext context = MathContext.DECIMAL128;

    public BigDecimalAccumulator() {
        this.sum = new BigDecimal(0, this.context);
    }

    @Override
    public void add(double term) {
        this.sum = this.sum.add(new BigDecimal(term), this.context);
    }

    @Override
    public void reset() {
        this.sum = new BigDecimal(0, this.context);
    }

    @Override
    public double sum() {
        return this.sum.doubleValue();
    }

    @Override
    public void set(double val) {
        this.sum = new BigDecimal(val, this.context);
    }
}

