/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.minpack;

import jdplus.toolkit.base.core.math.functions.FunctionException;
import jdplus.toolkit.base.core.math.functions.minpack.AbstractEstimator;
import jdplus.toolkit.base.core.math.functions.minpack.IEstimationProblem;

public class LevenbergMarquardtEstimator
extends AbstractEstimator {
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private double m_initialStepBoundFactor;
    private double m_costRelativeTolerance;
    private double m_parRelativeTolerance;
    private double m_orthoTolerance;
    private int maxIter = 100;
    private int iterCount;

    public LevenbergMarquardtEstimator() {
        this.setMaxCostEval(1000);
        this.m_initialStepBoundFactor = 100.0;
        this.m_costRelativeTolerance = 1.0E-7;
        this.m_parRelativeTolerance = 1.0E-7;
        this.m_orthoTolerance = 1.0E-7;
    }

    private void determineLMDirection(double[] qy, double[] diag, double[] lmDiag, double[] work) {
        int j;
        int pj;
        int j2;
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            pj = this.permutation[j2];
            for (int i = j2 + 1; i < this.solvedCols; ++i) {
                this.m_jacobian[i * this.m_cols + pj] = this.m_jacobian[j2 * this.m_cols + this.permutation[i]];
            }
            this.lmDir[j2] = this.diagR[pj];
            work[j2] = qy[j2];
        }
        for (j2 = 0; j2 < this.solvedCols; ++j2) {
            pj = this.permutation[j2];
            double dpj = diag[pj];
            if (dpj != 0.0) {
                for (int k = j2 + 1; k < lmDiag.length; ++k) {
                    lmDiag[k] = 0.0;
                }
            }
            lmDiag[j2] = dpj;
            double qtbpj = 0.0;
            for (int k = j2; k < this.solvedCols; ++k) {
                double cos;
                double sin;
                int pk = this.permutation[k];
                if (lmDiag[k] == 0.0) continue;
                double rkk = this.m_jacobian[k * this.m_cols + pk];
                if (Math.abs(rkk) < Math.abs(lmDiag[k])) {
                    double cotan = rkk / lmDiag[k];
                    sin = 1.0 / Math.sqrt(1.0 + cotan * cotan);
                    cos = sin * cotan;
                } else {
                    double tan = lmDiag[k] / rkk;
                    cos = 1.0 / Math.sqrt(1.0 + tan * tan);
                    sin = cos * tan;
                }
                this.m_jacobian[k * this.m_cols + pk] = cos * rkk + sin * lmDiag[k];
                double temp = cos * work[k] + sin * qtbpj;
                qtbpj = -sin * work[k] + cos * qtbpj;
                work[k] = temp;
                for (int i = k + 1; i < this.solvedCols; ++i) {
                    double rik = this.m_jacobian[i * this.m_cols + pk];
                    temp = cos * rik + sin * lmDiag[i];
                    lmDiag[i] = -sin * rik + cos * lmDiag[i];
                    this.m_jacobian[i * this.m_cols + pk] = temp;
                }
            }
            int index = j2 * this.m_cols + this.permutation[j2];
            lmDiag[j2] = this.m_jacobian[index];
            this.m_jacobian[index] = this.lmDir[j2];
        }
        int nSing = this.solvedCols;
        for (j = 0; j < this.solvedCols; ++j) {
            if (lmDiag[j] == 0.0 && nSing == this.solvedCols) {
                nSing = j;
            }
            if (nSing >= this.solvedCols) continue;
            work[j] = 0.0;
        }
        if (nSing > 0) {
            for (j = nSing - 1; j >= 0; --j) {
                int pj2 = this.permutation[j];
                double sum = 0.0;
                for (int i = j + 1; i < nSing; ++i) {
                    sum += this.m_jacobian[i * this.m_cols + pj2] * work[i];
                }
                work[j] = (work[j] - sum) / lmDiag[j];
            }
        }
        for (j = 0; j < this.lmDir.length; ++j) {
            this.lmDir[this.permutation[j]] = work[j];
        }
    }

    private void determineLMParameter(double[] qy, double delta, double[] diag, double[] work1, double[] work2, double[] work3) {
        int index;
        double sum;
        int pj;
        int j;
        int j2;
        for (j2 = 0; j2 < this.rank; ++j2) {
            this.lmDir[this.permutation[j2]] = qy[j2];
        }
        for (j2 = this.rank; j2 < this.m_cols; ++j2) {
            this.lmDir[this.permutation[j2]] = 0.0;
        }
        for (int k = this.rank - 1; k >= 0; --k) {
            int pk = this.permutation[k];
            double ypk = this.lmDir[pk] / this.diagR[pk];
            int i = 0;
            int index2 = pk;
            while (i < k) {
                int n = this.permutation[i];
                this.lmDir[n] = this.lmDir[n] - ypk * this.m_jacobian[index2];
                ++i;
                index2 += this.m_cols;
            }
            this.lmDir[pk] = ypk;
        }
        double dxNorm = 0.0;
        for (int j3 = 0; j3 < this.solvedCols; ++j3) {
            double s;
            int pj2 = this.permutation[j3];
            work1[pj2] = s = diag[pj2] * this.lmDir[pj2];
            dxNorm += s * s;
        }
        double fp = (dxNorm = Math.sqrt(dxNorm)) - delta;
        if (fp <= 0.1 * delta) {
            this.lmPar = 0.0;
            return;
        }
        double parl = 0.0;
        if (this.rank == this.solvedCols) {
            for (j = 0; j < this.solvedCols; ++j) {
                int n = pj = this.permutation[j];
                work1[n] = work1[n] * (diag[pj] / dxNorm);
            }
            double sum2 = 0.0;
            for (j = 0; j < this.solvedCols; ++j) {
                double s;
                pj = this.permutation[j];
                sum = 0.0;
                int i = 0;
                index = pj;
                while (i < j) {
                    sum += this.m_jacobian[index] * work1[this.permutation[i]];
                    ++i;
                    index += this.m_cols;
                }
                work1[pj] = s = (work1[pj] - sum) / this.diagR[pj];
                sum2 += s * s;
            }
            parl = fp / (delta * sum2);
        }
        double sum2 = 0.0;
        for (j = 0; j < this.solvedCols; ++j) {
            pj = this.permutation[j];
            sum = 0.0;
            int i = 0;
            index = pj;
            while (i <= j) {
                sum += this.m_jacobian[index] * qy[i];
                ++i;
                index += this.m_cols;
            }
            sum2 += (sum /= diag[pj]) * sum;
        }
        double gNorm = Math.sqrt(sum2);
        double paru = gNorm / delta;
        if (paru == 0.0) {
            paru = 2.2251E-308 / Math.min(delta, 0.1);
        }
        this.lmPar = Math.min(paru, Math.max(this.lmPar, parl));
        if (this.lmPar == 0.0) {
            this.lmPar = gNorm / dxNorm;
        }
        for (int countdown = 10; countdown >= 0; --countdown) {
            int pj3;
            int j4;
            int pj4;
            int j5;
            if (this.lmPar == 0.0) {
                this.lmPar = Math.max(2.2251E-308, 0.001 * paru);
            }
            double sPar = Math.sqrt(this.lmPar);
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                pj4 = this.permutation[j5];
                work1[pj4] = sPar * diag[pj4];
            }
            this.determineLMDirection(qy, work1, work2, work3);
            dxNorm = 0.0;
            for (j5 = 0; j5 < this.solvedCols; ++j5) {
                double s;
                pj4 = this.permutation[j5];
                work3[pj4] = s = diag[pj4] * this.lmDir[pj4];
                dxNorm += s * s;
            }
            dxNorm = Math.sqrt(dxNorm);
            double previousFP = fp;
            fp = dxNorm - delta;
            if (Math.abs(fp) <= 0.1 * delta || parl == 0.0 && fp <= previousFP && previousFP < 0.0) {
                return;
            }
            for (j4 = 0; j4 < this.solvedCols; ++j4) {
                pj3 = this.permutation[j4];
                work1[pj3] = work3[pj3] * diag[pj3] / dxNorm;
            }
            for (j4 = 0; j4 < this.solvedCols; ++j4) {
                int n = pj3 = this.permutation[j4];
                work1[n] = work1[n] / work2[j4];
                double tmp = work1[pj3];
                for (int i = j4 + 1; i < this.solvedCols; ++i) {
                    int n2 = this.permutation[i];
                    work1[n2] = work1[n2] - this.m_jacobian[i * this.m_cols + pj3] * tmp;
                }
            }
            sum2 = 0.0;
            for (j4 = 0; j4 < this.solvedCols; ++j4) {
                double s = work1[this.permutation[j4]];
                sum2 += s * s;
            }
            double correction = fp / (delta * sum2);
            if (fp > 0.0) {
                parl = Math.max(parl, this.lmPar);
            } else if (fp < 0.0) {
                paru = Math.min(paru, this.lmPar);
            }
            this.lmPar = Math.max(parl, this.lmPar + correction);
        }
    }

    @Override
    public void estimate(IEstimationProblem problem) {
        this.initializeEstimate(problem);
        this.solvedCols = Math.min(this.m_rows, this.m_cols);
        this.diagR = new double[this.m_cols];
        this.jacNorm = new double[this.m_cols];
        this.beta = new double[this.m_cols];
        this.permutation = new int[this.m_cols];
        this.lmDir = new double[this.m_cols];
        double delta = 0.0;
        double xNorm = 0.0;
        double[] diag = new double[this.m_cols];
        double[] oldX = new double[this.m_cols];
        double[] oldRes = new double[this.m_rows];
        double[] work1 = new double[this.m_cols];
        double[] work2 = new double[this.m_cols];
        double[] work3 = new double[this.m_cols];
        this.updateResidualsAndCost(problem);
        this.lmPar = 0.0;
        boolean firstIteration = true;
        this.iterCount = 0;
        block0: while (this.iterCount++ < this.maxIter) {
            int j;
            int k;
            this.updateJacobian(problem);
            this.qrDecomposition();
            this.qTy(this.m_residuals);
            for (k = 0; k < this.solvedCols; ++k) {
                int pk = this.permutation[k];
                this.m_jacobian[k * this.m_cols + pk] = this.diagR[pk];
            }
            if (firstIteration) {
                xNorm = 0.0;
                for (k = 0; k < this.m_cols; ++k) {
                    double dk = this.jacNorm[k];
                    if (dk == 0.0) {
                        dk = 1.0;
                    }
                    double xk = dk * problem.getUnboundParameterEstimate(k);
                    xNorm += xk * xk;
                    diag[k] = dk;
                }
                delta = (xNorm = Math.sqrt(xNorm)) == 0.0 ? this.m_initialStepBoundFactor : this.m_initialStepBoundFactor * xNorm;
            }
            double maxCosine = 0.0;
            if (this.m_cost != 0.0) {
                for (j = 0; j < this.solvedCols; ++j) {
                    int pj = this.permutation[j];
                    double s = this.jacNorm[pj];
                    if (s == 0.0) continue;
                    double sum = 0.0;
                    int i = 0;
                    int index = pj;
                    while (i <= j) {
                        sum += this.m_jacobian[index] * this.m_residuals[i];
                        ++i;
                        index += this.m_cols;
                    }
                    maxCosine = Math.max(maxCosine, Math.abs(sum) / (s * this.m_cost));
                }
            }
            if (maxCosine <= this.m_orthoTolerance) {
                return;
            }
            for (j = 0; j < this.m_cols; ++j) {
                diag[j] = Math.max(diag[j], this.jacNorm[j]);
            }
            double ratio = 0.0;
            while (ratio < 1.0E-4) {
                for (int j2 = 0; j2 < this.solvedCols; ++j2) {
                    int pj = this.permutation[j2];
                    oldX[pj] = problem.getUnboundParameterEstimate(pj);
                }
                double previousCost = this.m_cost;
                double[] tmpVec = this.m_residuals;
                this.m_residuals = oldRes;
                oldRes = tmpVec;
                this.determineLMParameter(oldRes, delta, diag, work1, work2, work3);
                double lmNorm = 0.0;
                for (int j3 = 0; j3 < this.solvedCols; ++j3) {
                    int pj = this.permutation[j3];
                    this.lmDir[pj] = -this.lmDir[pj];
                    problem.setUnboundParameterEstimate(pj, oldX[pj] + this.lmDir[pj]);
                    double s = diag[pj] * this.lmDir[pj];
                    lmNorm += s * s;
                }
                lmNorm = Math.sqrt(lmNorm);
                if (firstIteration) {
                    delta = Math.min(delta, lmNorm);
                }
                if (!this.updateResidualsAndCost(problem)) continue block0;
                double actRed = -1.0;
                if (0.1 * this.m_cost < previousCost) {
                    double r = this.m_cost / previousCost;
                    actRed = 1.0 - r * r;
                }
                for (int j4 = 0; j4 < this.solvedCols; ++j4) {
                    int pj = this.permutation[j4];
                    double dirJ = this.lmDir[pj];
                    work1[j4] = 0.0;
                    int i = 0;
                    int index = pj;
                    while (i <= j4) {
                        int n = i++;
                        work1[n] = work1[n] + this.m_jacobian[index] * dirJ;
                        index += this.m_cols;
                    }
                }
                double coeff1 = 0.0;
                for (int j5 = 0; j5 < this.solvedCols; ++j5) {
                    coeff1 += work1[j5] * work1[j5];
                }
                double pc2 = previousCost * previousCost;
                double coeff2 = this.lmPar * lmNorm * lmNorm / pc2;
                double preRed = (coeff1 /= pc2) + 2.0 * coeff2;
                double dirDer = -(coeff1 + coeff2);
                double d = ratio = preRed == 0.0 ? 0.0 : actRed / preRed;
                if (ratio <= 0.25) {
                    double tmp;
                    double d2 = tmp = actRed < 0.0 ? 0.5 * dirDer / (dirDer + 0.5 * actRed) : 0.5;
                    if (0.1 * this.m_cost >= previousCost || tmp < 0.1) {
                        tmp = 0.1;
                    }
                    delta = tmp * Math.min(delta, 10.0 * lmNorm);
                    this.lmPar /= tmp;
                } else if (this.lmPar == 0.0 || ratio >= 0.75) {
                    delta = 2.0 * lmNorm;
                    this.lmPar *= 0.5;
                }
                if (ratio >= 1.0E-4) {
                    firstIteration = false;
                    xNorm = 0.0;
                    for (int k2 = 0; k2 < this.m_cols; ++k2) {
                        double xK = diag[k2] * problem.getUnboundParameterEstimate(k2);
                        xNorm += xK * xK;
                    }
                    xNorm = Math.sqrt(xNorm);
                } else {
                    this.m_cost = previousCost;
                    for (int j6 = 0; j6 < this.solvedCols; ++j6) {
                        int pj = this.permutation[j6];
                        problem.setUnboundParameterEstimate(pj, oldX[pj]);
                    }
                    tmpVec = this.m_residuals;
                    this.m_residuals = oldRes;
                    oldRes = tmpVec;
                    problem.compute();
                }
                if (Math.abs(actRed) <= this.m_costRelativeTolerance && preRed <= this.m_costRelativeTolerance && ratio <= 2.0 || delta <= this.m_parRelativeTolerance * xNorm) {
                    return;
                }
                if (Math.abs(actRed) <= 2.2204E-16 && preRed <= 2.2204E-16 && ratio <= 2.0) {
                    throw new FunctionException("Minpack: cost relative tolerance is too small");
                }
                if (delta <= 2.2204E-16 * xNorm) {
                    throw new FunctionException("Minpack: parameters relative tolerance is too small");
                }
                if (!(maxCosine <= 2.2204E-16)) continue;
                throw new FunctionException("Minpack: orthogonality tolerance is too small");
            }
        }
    }

    public double getCostRelativeTolerance() {
        return this.m_costRelativeTolerance;
    }

    public double getInitialStepBoundFactor() {
        return this.m_initialStepBoundFactor;
    }

    public int getIterCount() {
        return this.iterCount;
    }

    public int getMaxIter() {
        return this.maxIter;
    }

    public double getOrthogonalTolerance() {
        return this.m_orthoTolerance;
    }

    public double getParametersRelativeTolerance() {
        return this.m_parRelativeTolerance;
    }

    private void qrDecomposition() {
        int k;
        for (k = 0; k < this.m_cols; ++k) {
            this.permutation[k] = k;
            double norm2 = 0.0;
            for (int index = k; index < this.m_jacobian.length; index += this.m_cols) {
                double akk = this.m_jacobian[index];
                norm2 += akk * akk;
            }
            this.jacNorm[k] = Math.sqrt(norm2);
        }
        for (k = 0; k < this.m_cols; ++k) {
            double betak;
            int nextColumn = -1;
            double ak2 = Double.NEGATIVE_INFINITY;
            for (int i = k; i < this.m_cols; ++i) {
                int iDiag;
                double norm2 = 0.0;
                for (int index = iDiag = k * this.m_cols + this.permutation[i]; index < this.m_jacobian.length; index += this.m_cols) {
                    double aki = this.m_jacobian[index];
                    norm2 += aki * aki;
                }
                if (!(norm2 > ak2)) continue;
                nextColumn = i;
                ak2 = norm2;
            }
            if (ak2 == 0.0) {
                this.rank = k;
                return;
            }
            int pk = this.permutation[nextColumn];
            this.permutation[nextColumn] = this.permutation[k];
            this.permutation[k] = pk;
            int kDiag = k * this.m_cols + pk;
            double akk = this.m_jacobian[kDiag];
            double alpha = akk > 0.0 ? -Math.sqrt(ak2) : Math.sqrt(ak2);
            this.beta[pk] = betak = 1.0 / (ak2 - akk * alpha);
            this.diagR[pk] = alpha;
            int n = kDiag;
            this.m_jacobian[n] = this.m_jacobian[n] - alpha;
            for (int dk = this.m_cols - 1 - k; dk > 0; --dk) {
                int index;
                int dkp = this.permutation[k + dk] - pk;
                double gamma = 0.0;
                for (index = kDiag; index < this.m_jacobian.length; index += this.m_cols) {
                    gamma += this.m_jacobian[index] * this.m_jacobian[index + dkp];
                }
                gamma *= betak;
                for (index = kDiag; index < this.m_jacobian.length; index += this.m_cols) {
                    int n2 = index + dkp;
                    this.m_jacobian[n2] = this.m_jacobian[n2] - gamma * this.m_jacobian[index];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] y) {
        for (int k = 0; k < this.m_cols; ++k) {
            int pk = this.permutation[k];
            int kDiag = k * this.m_cols + pk;
            double gamma = 0.0;
            int i = k;
            int index = kDiag;
            while (i < this.m_rows) {
                gamma += this.m_jacobian[index] * y[i];
                ++i;
                index += this.m_cols;
            }
            gamma *= this.beta[pk];
            i = k;
            index = kDiag;
            while (i < this.m_rows) {
                int n = i++;
                y[n] = y[n] - gamma * this.m_jacobian[index];
                index += this.m_cols;
            }
        }
    }

    public void setCostRelativeTolerance(double value) {
        this.m_costRelativeTolerance = value;
    }

    public void setInitialStepBoundFactor(double value) {
        this.m_initialStepBoundFactor = value;
    }

    public void setMaxIter(int maxIter) {
        this.maxIter = maxIter;
    }

    public void setOrthogonalTolerance(double value) {
        this.m_orthoTolerance = value;
    }

    public void setParametersRelativeTolerance(double value) {
        this.m_parRelativeTolerance = value;
    }
}

