/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IQuasiSymmetricFiltering;

public interface ISymmetricFiltering
extends IQuasiSymmetricFiltering {
    @Override
    default public DoubleSeq process(DoubleSeq in) {
        return FilterUtility.filter(in, this.centralFilter(), this.endPointsFilters());
    }

    @Override
    default public void inPlaceProcess(DoubleSeq in, DataBlock out) {
        FilterUtility.inPlaceFilter(in, out, this.centralFilter(), this.endPointsFilters());
    }

    public IFiniteFilter[] endPointsFilters();

    @Override
    default public IFiniteFilter[] leftEndPointsFilters() {
        return ISymmetricFiltering.mirror(this.endPointsFilters());
    }

    @Override
    default public IFiniteFilter[] rightEndPointsFilters() {
        return this.endPointsFilters();
    }

    public static IFiniteFilter[] mirror(IFiniteFilter[] rightEndPoints) {
        IFiniteFilter[] lf = (IFiniteFilter[])rightEndPoints.clone();
        for (int i = 0; i < lf.length; ++i) {
            lf[i] = lf[i].mirror();
        }
        return lf;
    }
}

