/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarUtility;
import jdplus.toolkit.base.api.timeseries.regression.LengthOfPeriod;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class LPFactory
implements RegressionVariableFactory<LengthOfPeriod> {
    static LPFactory FACTORY = new LPFactory();

    private LPFactory() {
    }

    @Override
    public boolean fill(LengthOfPeriod var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        switch (var.getType()) {
            case LeapYear: {
                this.lp(TsDomain.of((TsPeriod)start, (int)buffer.getRowsCount()), buffer.column(0));
                return true;
            }
            case LengthOfPeriod: {
                this.length(TsDomain.of((TsPeriod)start, (int)buffer.getRowsCount()), buffer.column(0));
                return true;
            }
        }
        return false;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(LengthOfPeriod var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void lp(TsDomain domain, DataBlock buffer) {
        int pos;
        int idx;
        int freq = domain.getAnnualFrequency();
        TsPeriod start = domain.getStartPeriod();
        if (!start.getEpoch().equals(TsPeriod.DEFAULT_EPOCH)) {
            throw new UnsupportedOperationException();
        }
        int n = domain.getLength();
        int period = 0;
        if (freq == 12) {
            period = 1;
        }
        if ((idx = period - (pos = (start.start().getMonthValue() - 1) % freq)) < 0) {
            idx += freq;
        }
        int lppos = idx;
        int year = domain.get(idx).year();
        while (!CalendarUtility.isLeap((int)year)) {
            lppos += freq;
            ++year;
        }
        buffer.extract(idx, -1, freq).set(-0.25);
        buffer.extract(lppos, -1, 4 * freq).set(0.75);
    }

    private void length(TsDomain domain, DataBlock buffer) {
        int freq = domain.getAnnualFrequency();
        TsPeriod start = domain.getStartPeriod();
        if (!start.getEpoch().equals(TsPeriod.DEFAULT_EPOCH)) {
            throw new UnsupportedOperationException();
        }
        int[] ndays = CalendarUtility.daysCount((TsDomain)domain);
        double m = 365.25 / (double)freq;
        buffer.set(i -> (double)ndays[i] - m);
    }
}

