/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.dk;

import jdplus.toolkit.base.api.dstats.RandomNumberGenerator;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.Normal;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.random.JdkRNG;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfError;

public class RandomGenerator {
    private static final Normal N = new Normal();
    private static final RandomNumberGenerator RNG = JdkRNG.newRandom(0L);
    private static final double EPS = 1.0E-8;
    private FastMatrix LA;
    private final ISsf ssf;
    private final ISsfDynamics dynamics;
    private final ISsfLoading loading;
    private final ISsfError error;
    private double svar = 1.0;
    private double dvar = 100.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillRandoms(DataBlock u) {
        Normal normal = N;
        synchronized (normal) {
            for (int i = 0; i < u.length(); ++i) {
                u.set(i, N.random(RNG));
            }
        }
    }

    public RandomGenerator(ISsf ssf) {
        this.ssf = ssf;
        this.dynamics = ssf.dynamics();
        this.loading = ssf.loading();
        this.error = ssf.measurementError();
        this.initSsf();
    }

    public double[] newRandom(int n) {
        return new RandomData(n).getRandomData();
    }

    private double lh(int pos) {
        return this.error == null ? 0.0 : Math.sqrt(this.error.at(pos));
    }

    private double h(int pos) {
        return this.error == null ? 0.0 : this.error.at(pos);
    }

    private void initSsf() {
        int dim = this.ssf.getStateDim();
        this.LA = FastMatrix.square(dim);
        this.ssf.initialization().Pf0(this.LA);
        SymmetricMatrix.lcholesky(this.LA, 1.0E-8);
    }

    private void generateTransitionRandoms(int pos, DataBlock u) {
        RandomGenerator.fillRandoms(u);
    }

    private void generateMeasurementRandoms(DataBlock e) {
        RandomGenerator.fillRandoms(e);
        e.mul(this.lh(0));
    }

    private void generateInitialState(DataBlock a) {
        RandomGenerator.fillRandoms(a);
        LowerTriangularMatrix.Lx(this.LA, a);
        double std = Math.sqrt(this.svar);
        a.mul(std);
        ISsfInitialization initialization = this.ssf.initialization();
        if (initialization.isDiffuse()) {
            DataBlock b = DataBlock.make(initialization.getDiffuseDim());
            RandomGenerator.fillRandoms(b);
            double dstd = Math.sqrt(this.dvar);
            b.mul(dstd);
            FastMatrix B = FastMatrix.make(a.length(), b.length());
            initialization.diffuseConstraints(B);
            a.addProduct(B.rowsIterator(), b);
        }
    }

    class RandomData {
        private final int dim;
        private final int resdim;
        private final int n;
        final double[] measurementErrors;
        private final double[] simulatedData;

        public RandomData(int n) {
            this.n = n;
            this.dim = RandomGenerator.this.ssf.initialization().getStateDim();
            this.resdim = RandomGenerator.this.dynamics.getInnovationsDim();
            if (RandomGenerator.this.error != null) {
                this.measurementErrors = new double[n];
                RandomGenerator.this.generateMeasurementRandoms(DataBlock.of(this.measurementErrors));
            } else {
                this.measurementErrors = null;
            }
            this.simulatedData = new double[n];
            this.generateData();
        }

        private void generateData() {
            DataBlock a = DataBlock.make(this.dim);
            RandomGenerator.this.generateInitialState(a);
            double std = Math.sqrt(RandomGenerator.this.svar);
            this.simulatedData[0] = RandomGenerator.this.loading.ZX(0, a);
            if (this.measurementErrors != null) {
                this.simulatedData[0] = this.simulatedData[0] + this.measurementErrors[0] * std;
            }
            DataBlock q = DataBlock.make(this.resdim);
            for (int i = 1; i < this.simulatedData.length; ++i) {
                RandomGenerator.this.dynamics.TX(i, a);
                if (RandomGenerator.this.dynamics.hasInnovations(i - 1)) {
                    RandomGenerator.this.generateTransitionRandoms(i - 1, q);
                    q.mul(std);
                    RandomGenerator.this.dynamics.addSU(i - 1, a, q);
                }
                this.simulatedData[i] = RandomGenerator.this.loading.ZX(i, a);
                if (this.measurementErrors == null) continue;
                int n = i;
                this.simulatedData[n] = this.simulatedData[n] + this.measurementErrors[i] * std;
            }
        }

        public double[] getRandomData() {
            return this.simulatedData;
        }
    }
}

