/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.linearmodel;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;

public class HeteroskedasticityTest {
    private Type type = Type.BreuschPagan;
    private boolean fisher = false;
    private boolean studentized = false;
    private final LeastSquaresResults lsr;
    private LeastSquaresResults lsr2;

    public static HeteroskedasticityTest builder(LinearModel lm) {
        return new HeteroskedasticityTest(Ols.compute(lm));
    }

    public static HeteroskedasticityTest builder(LeastSquaresResults lsr) {
        return new HeteroskedasticityTest(lsr);
    }

    private HeteroskedasticityTest(LeastSquaresResults lsr) {
        this.lsr = lsr;
    }

    public HeteroskedasticityTest studentizedResiduals(boolean studentized) {
        this.studentized = studentized;
        return this;
    }

    public HeteroskedasticityTest type(Type type) {
        this.type = type;
        return this;
    }

    public HeteroskedasticityTest fisherTest(boolean fisher) {
        this.fisher = fisher;
        return this;
    }

    public StatisticalTest build() {
        if (!this.lsr.isMean()) {
            throw new IllegalArgumentException("lm should contain a mean correction");
        }
        Matrix X = this.lsr.X();
        DoubleSeq e = this.studentized ? this.lsr.studentizedResiduals() : this.lsr.residuals();
        int n = X.getRowsCount();
        int m = X.getColumnsCount();
        LinearModel.Builder builder = LinearModel.builder().y(e.fastOp(z -> z * z)).addX(X.extract(0, n, 1, m - 1)).meanCorrection(true);
        if (this.type == Type.White) {
            for (int i = 1; i < m; ++i) {
                for (int j = i; j < m; ++j) {
                    builder.addX(X.column(i).fastOp(X.column(j), (xi, xj) -> xi * xj));
                }
            }
        }
        this.lsr2 = Ols.compute(builder.build());
        if (this.fisher) {
            return this.lsr2.Ftest();
        }
        return this.lsr2.Khi2Test();
    }

    public LeastSquaresResults getLeastSquaresResultsOnSquaredResiduals() {
        return this.lsr2;
    }

    public static enum Type {
        BreuschPagan,
        White;

    }
}

