/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.Map;
import java.util.function.Function;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractor;
import jdplus.toolkit.base.api.util.WildCards;

public abstract class DynamicMapping<S, M>
implements InformationExtractor<S> {
    private final String prefix;
    private final Function<S, Map<String, M>> fn;

    public DynamicMapping(String prefix, Function<S, Map<String, M>> fn) {
        this.prefix = prefix;
        this.fn = fn;
    }

    @Override
    public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
    }

    @Override
    public boolean contains(String id) {
        return false;
    }

    @Override
    public <Q> Q getData(S source, String id, Class<Q> qclass) {
        M rslt;
        if (source == null) {
            return null;
        }
        Map<String, M> map = this.fn.apply(source);
        String subitem = id;
        if (this.prefix != null) {
            if (id.length() <= this.prefix.length()) {
                return null;
            }
            if (!id.startsWith(this.prefix) || id.charAt(this.prefix.length()) != '.') {
                return null;
            }
            subitem = id.substring(this.prefix.length() + 1);
        }
        if ((rslt = map.get(subitem)) != null && qclass.isInstance(rslt)) {
            return (Q)rslt;
        }
        return null;
    }

    @Override
    public <Q> void searchAll(S source, WildCards wc, Class<Q> tclass, Map<String, Q> map) {
        if (source == null) {
            return;
        }
        Map<String, M> cmap = this.fn.apply(source);
        cmap.forEach((key, value) -> {
            if (wc.match((String)key) && tclass.isInstance(value)) {
                map.put(BasicInformationExtractor.concatenate(this.prefix, key), value);
            }
        });
    }
}

