/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.information.InformationSet;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarDefinition;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarManager;
import jdplus.toolkit.base.api.timeseries.regression.TsDataSuppliers;
import jdplus.toolkit.base.api.util.DefaultNameValidator;
import jdplus.toolkit.base.api.util.INameValidator;
import jdplus.toolkit.base.api.util.NameManager;

public class ModellingContext {
    public static final String LEGACY = "legacy";
    private final HashMap<Class, NameManager> map = new HashMap();
    private static final AtomicReference<ModellingContext> DEF_CONTEXT = new AtomicReference<ModellingContext>(new ModellingContext());

    public ModellingContext() {
        this.map.put(TsDataSuppliers.class, new NameManager<TsDataSuppliers>(TsDataSuppliers.class, "Variables_", new DefaultNameValidator(".")));
        this.map.put(CalendarDefinition.class, new CalendarManager());
    }

    public CalendarManager getCalendars() {
        return (CalendarManager)this.map.get(CalendarDefinition.class);
    }

    public NameManager<TsDataSuppliers> getTsVariableManagers() {
        return this.map.get(TsDataSuppliers.class);
    }

    public TsDataSuppliers getTsVariables(String family) {
        NameManager obj = this.map.get(TsDataSuppliers.class);
        if (obj == null) {
            return null;
        }
        NameManager mgr = obj;
        return (TsDataSuppliers)mgr.get(family);
    }

    public TsDataSupplier getTsVariable(String family, String var) {
        NameManager obj = this.map.get(TsDataSuppliers.class);
        if (obj == null) {
            return null;
        }
        NameManager mgr = obj;
        TsDataSuppliers vars = (TsDataSuppliers)mgr.get(family);
        if (vars == null) {
            return null;
        }
        return (TsDataSupplier)vars.get(var);
    }

    public TsDataSupplier getTsVariable(String name) {
        String[] s = InformationSet.split(name);
        if (s.length == 1) {
            return this.getTsVariable(LEGACY, s[0]);
        }
        if (s.length != 2) {
            return null;
        }
        return this.getTsVariable(s[0], s[1]);
    }

    public List<String> getTsVariableDictionary() {
        ArrayList<String> all = new ArrayList<String>();
        NameManager<TsDataSuppliers> mgrs = this.getTsVariableManagers();
        String[] groups = mgrs.getNames();
        for (int i = 0; i < groups.length; ++i) {
            TsDataSuppliers tv = mgrs.get(groups[i]);
            String[] vars = tv.getNames();
            for (int j = 0; j < vars.length; ++j) {
                all.add(InformationSet.item(groups[i], vars[j]));
            }
        }
        return all;
    }

    public <T> boolean add(Class<T> tclass, String prefix, INameValidator validator) {
        if (this.map.containsKey(tclass)) {
            return false;
        }
        this.map.put(tclass, new NameManager<T>(tclass, prefix, validator));
        return true;
    }

    public Collection<Class> getTypes() {
        return this.map.keySet();
    }

    public <T> NameManager<T> getInformation(Class<T> tclass) {
        return this.map.get(tclass);
    }

    public static ModellingContext getActiveContext() {
        return DEF_CONTEXT.get();
    }

    public static void setActiveContext(ModellingContext context) {
        DEF_CONTEXT.set(context);
    }

    public boolean isDirty() {
        for (NameManager mgr : this.map.values()) {
            if (!mgr.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        for (NameManager mgr : this.map.values()) {
            mgr.resetDirty();
        }
    }

    public void clear() {
        for (NameManager mgr : this.map.values()) {
            mgr.clear();
        }
    }

    public void resetDefault() {
        this.map.clear();
        this.map.put(TsDataSuppliers.class, new NameManager<TsDataSuppliers>(TsDataSuppliers.class, "Variables_", new DefaultNameValidator(".")));
    }
}

