/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import java.util.Collections;
import java.util.List;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsFactory;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.modelling.regular.tests.SpectralAnalysis;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SpectralDiagnostics
implements Diagnostics {
    private boolean sorig;
    private boolean ssa;
    private boolean sirr;
    private boolean tdsa;
    private boolean tdirr;
    private boolean strict;

    protected static SpectralDiagnostics of(SpectralDiagnosticsConfiguration config, Input input) {
        try {
            if (input == null) {
                return null;
            }
            SpectralDiagnostics diags = new SpectralDiagnostics();
            if (diags.test(input, config.getSensibility(), config.getLength(), config.isStrict())) {
                return diags;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean test(Input input, double sens, int len, boolean strict) {
        this.strict = strict;
        try {
            TimeSelector sel;
            SpectralAnalysis diag;
            boolean r = false;
            TsData s = input.getY();
            int sfreq = s.getAnnualFrequency();
            if (input.mode.isMultiplicative()) {
                s = s.log();
            }
            s = s.delta(1);
            if (len != 0) {
                TimeSelector sel2 = TimeSelector.last((int)(len * sfreq));
                s = s.select(sel2);
            }
            if ((diag = SpectralAnalysis.test((TsData)s).sensibility(sens).arLength(sfreq == 12 ? 30 : 3 * sfreq).build()) != null) {
                this.sorig = diag.hasSeasonalPeaks();
                r = true;
            }
            s = input.getSa();
            if (input.mode.isMultiplicative()) {
                s = s.log();
            }
            int del = Math.max(1, sfreq / 4);
            s = s.delta(del);
            if (len != 0) {
                sel = TimeSelector.last((int)(len * sfreq));
                s = s.select(sel);
            }
            if ((diag = SpectralAnalysis.test((TsData)s).sensibility(sens).arLength(sfreq == 12 ? 30 : 3 * sfreq).build()) != null) {
                r = true;
                this.ssa = diag.hasSeasonalPeaks();
                if (sfreq == 12) {
                    this.tdsa = diag.hasTradingDayPeaks();
                }
            }
            if (len != 0) {
                r = true;
                sel = TimeSelector.last((int)(len * sfreq));
                s = s.select(sel);
            }
            if ((diag = SpectralAnalysis.test((TsData)s).sensibility(sens).arLength(sfreq == 12 ? 30 : 3 * sfreq).build()) != null) {
                r = true;
                this.sirr = diag.hasSeasonalPeaks();
                if (sfreq == 12) {
                    this.tdirr = diag.hasTradingDayPeaks();
                }
            }
            return r;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getName() {
        return "Visual spectral analysis";
    }

    public List<String> getTests() {
        return SpectralDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (test.equals("spectral seas peaks")) {
            if (!this.sirr && !this.ssa) {
                return ProcQuality.Good;
            }
            if (this.sirr && this.ssa) {
                return this.strict ? ProcQuality.Severe : ProcQuality.Bad;
            }
            return ProcQuality.Uncertain;
        }
        if (test.equals("spectral td peaks")) {
            if (!this.tdirr && !this.tdsa) {
                return ProcQuality.Good;
            }
            if (this.tdirr && this.tdsa) {
                return this.strict ? ProcQuality.Severe : ProcQuality.Bad;
            }
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        return Double.NaN;
    }

    public List<String> getWarnings() {
        if (!this.sorig) {
            return Collections.singletonList("No seasonal peak in the original differenced series");
        }
        return Collections.emptyList();
    }

    public static final class Input {
        private final DecompositionMode mode;
        private final TsData y;
        private final TsData sa;

        @Generated
        public Input(DecompositionMode mode, TsData y, TsData sa) {
            this.mode = mode;
            this.y = y;
            this.sa = sa;
        }

        @Generated
        public DecompositionMode getMode() {
            return this.mode;
        }

        @Generated
        public TsData getY() {
            return this.y;
        }

        @Generated
        public TsData getSa() {
            return this.sa;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Input)) {
                return false;
            }
            Input other = (Input)o;
            DecompositionMode this$mode = this.getMode();
            DecompositionMode other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            TsData this$y = this.getY();
            TsData other$y = other.getY();
            if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
                return false;
            }
            TsData this$sa = this.getSa();
            TsData other$sa = other.getSa();
            return !(this$sa == null ? other$sa != null : !this$sa.equals(other$sa));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DecompositionMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            TsData $y = this.getY();
            result = result * 59 + ($y == null ? 43 : $y.hashCode());
            TsData $sa = this.getSa();
            result = result * 59 + ($sa == null ? 43 : $sa.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "SpectralDiagnostics.Input(mode=" + String.valueOf(this.getMode()) + ", y=" + String.valueOf(this.getY()) + ", sa=" + String.valueOf(this.getSa()) + ")";
        }
    }
}

