% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{chained_calendar}
\alias{chained_calendar}
\title{Create a Chained Calendar}
\usage{
chained_calendar(calendar1, calendar2, break_date)
}
\arguments{
\item{calendar1, calendar2}{calendars to chain.}

\item{break_date}{the break date in the format \code{"YYYY-MM-DD"}.}
}
\value{
returns an object of class \code{c("JD3_CHAINEDCALENDAR","JD3_CALENDARDEFINITION")}
}
\description{
Allows to combine two calendars, one before and one after a given date.
}
\details{
A chained calendar is an useful option when major changes in the composition of the holidays take place.
In such a case two calendars describing the situation before and after the change of regime can be defined
and bound together, one before the break and one after the break.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
Belgium <- national_calendar(list(special_day("NEWYEAR"), fixed_day(7, 21)))
France <- national_calendar(list(special_day("NEWYEAR"), fixed_day(7, 14)))
chained_cal <- chained_calendar(France, Belgium, "2000-01-01")
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{national_calendar}}, \code{\link{weighted_calendar}}
}
