% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_regular.R
\name{mad}
\alias{mad}
\title{Compute a robust median absolute deviation (MAD)}
\usage{
mad(data, centile = 50, medianCorrected = TRUE)
}
\arguments{
\item{data}{The data for which we compute the robust deviation}

\item{centile}{The centile used to exclude extreme values (only the "centile" part of the data are is to compute the mad)}

\item{medianCorrected}{TRUE if the series is corrected for its median, FALSE if the median is supposed to be 0}
}
\value{
The median absolute deviation
}
\description{
Compute a robust median absolute deviation (MAD)
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
y <- rnorm(1000)
m <- rjd3toolkit::mad(y, centile = 70)
\dontshow{\}) # examplesIf}
}
