% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_regarima.R
\name{set_arima}
\alias{set_arima}
\title{Set ARIMA Model Structure in Pre-Processing Specification}
\usage{
set_arima(
  x,
  mean = NA,
  mean.type = c(NA, "Undefined", "Fixed", "Initial"),
  p = NA,
  d = NA,
  q = NA,
  bp = NA,
  bd = NA,
  bq = NA,
  coef = NA,
  coef.type = c(NA, "Undefined", "Fixed", "Initial")
)
}
\arguments{
\item{x}{the specification to customize, must be a "SPEC" class object (see
details).}

\item{mean}{to fix the coefficient of the mean. If \code{mean = 0}, the mean is disabled.}

\item{mean.type}{a character defining the mean coefficient estimation procedure.
Possible procedures are: \code{"Undefined"} = no use of any user-defined input (i.e. coefficient is estimated),
\code{"Fixed"} = the coefficients are fixed at the value provided by the user,
\code{"Initial"} = the value defined by the user is used as the initial condition.}

\item{p, d, q, bp, bd, bq}{to specify the order of the SARIMA model in the form ARIMA(p,d,q)(bp,bd,bd).}

\item{coef}{a vector providing the coefficients for the regular and seasonal AR and MA polynomials.
The vector length must be equal to the sum of the regular and seasonal AR and MA orders.
The coefficients shall be provided in the following order: regular AR (\emph{Phi}; \code{p} elements),
regular MA  (\emph{Theta}; \code{q} elements), seasonal AR (\emph{BPhi}; \code{bp} elements)
and seasonal MA (\emph{BTheta}; \code{bq} elements).
E.g.: \code{arima.coef=c(0.6,0.7)} with \code{p=1, q=0,bp=1} and \code{bq=0}.}

\item{coef.type}{a vector defining the ARMA coefficients estimation procedure.
Possible procedures are: \code{"Undefined"} = no use of any user-defined input (i.e. coefficients are estimated),
\code{"Fixed"} = the coefficients are fixed at the value provided by the user,
\code{"Initial"} = the value defined by the user is used as the initial condition.}
}
\value{
The modified specification (with new ARIMA model)
}
\description{
Function allowing to customize the ARIMA model structure
when the automatic modelling is disabled.(see example)
}
\details{
\code{x} specification parameter must be a JD3_X13_SPEC" class object generated with \code{rjd3x13::x13_spec()}
(or "JD3_REGARIMA_SPEC" generated with \code{rjd3x13::spec_regarima()} or "JD3_TRAMOSEATS_SPEC"
generated with \code{rjd3tramoseats::spec_tramoseats()} or "JD3_TRAMO_SPEC" generated with
\code{rjd3tramoseats::spec_tramo()}).
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Customize a default specification
init_spec <- x13_spec_default

# Disable automatic arima modelling
new_spec <- set_automodel(init_spec, enabled = FALSE)

# Customize arima model
new_spec <- set_arima(
    x = new_spec,
    mean = 0.2,
    mean.type = "Fixed",
    p = 1,
    d = 2,
    q = 0,
    bp = 1,
    bd = 1,
    bq = 0,
    coef = c(0.6, 0.7),
    coef.type = c("Initial", "Fixed")
)
\dontshow{\}) # examplesIf}
}
\references{
More information on reg-arima modelling in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{set_automodel}}, \code{\link{set_transform}}
}
