% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries.R
\name{tsdata_of}
\alias{tsdata_of}
\title{Create ts object with values and dates}
\usage{
tsdata_of(values, dates)
}
\arguments{
\item{values}{Values of the time series}

\item{dates}{Dates of the values (could be any date inside the considered period)}
}
\value{
A \code{ts} object. The frequency will be identified automatically and missing values will be added in need be.
The identified frequency will be the lowest frequency that match the figures.
The provided data can contain missing values (NA)
}
\description{
Create ts object with values and dates
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
# Annual series
s <- tsdata_of(c(1, 2, 3, 4), c("1990-01-01", "1995-01-01", "1996-01-01",
        "2000-11-01"))
# Quarterly series
t <- tsdata_of(c(1, 2, 3, NA, 4), c("1990-01-01", "1995-01-01", "1996-01-01",
        "2000-08-01", "2000-11-01"))
\dontshow{\}) # examplesIf}
}
